/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Project;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.conversion.JsonPatchBuilder;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.CommonReferenceNames;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.SchemeBuilder;

public class WorkItemDefinition {
    public final String organizationName;
    public final String projectName;
    public final String workItemType;
    public final List<JsonPatchBuilder.Operation> operations;
    static List<String> ignoredFields = Arrays.asList(CommonReferenceNames.WorkItemType.value, "attachments", "template");

    private WorkItemDefinition(String organizationName, String projectName, String workItemType, List<JsonPatchBuilder.Operation> operations) {
        this.organizationName = organizationName;
        this.projectName = projectName;
        this.workItemType = workItemType;
        this.operations = operations;
    }

    public static WorkItemDefinition from(AdvancedIssue advancedIssue) {
        String projectPath = advancedIssue.getProject().getId();
        String organizationName = Project.extractOrganizationName(projectPath);
        String projectName = Project.extractProjectName(projectPath);
        String workItemType = WorkItemDefinition.extractWorkItemType(advancedIssue);
        List<JsonPatchBuilder.Operation> operations = WorkItemDefinition.asOperations(advancedIssue.getFieldValues(), workItemType);
        return new WorkItemDefinition(organizationName, projectName, workItemType, operations);
    }

    private static List<JsonPatchBuilder.Operation> asOperations(Map<String, FieldValue> fieldValues, String workItemType) {
        JsonPatchBuilder builder = new JsonPatchBuilder();
        fieldValues.entrySet().stream().filter(entry -> !ignoredFields.contains(entry.getKey())).forEach(entry -> {
            String referenceName = SchemeBuilder.removeWorkItemTypePrefix((String)entry.getKey(), workItemType);
            String value = WorkItemDefinition.extractValue(referenceName, (FieldValue)entry.getValue());
            builder.add("/fields/" + referenceName, value);
        });
        return builder.getOperations();
    }

    private static String extractValue(String referenceName, FieldValue value) {
        if (referenceName.equals(CommonReferenceNames.Tags.value)) {
            List compositeScalars = Arrays.stream(value.getComposite()).map(FieldValue::getScalar).collect(Collectors.toList());
            return String.join((CharSequence)",", compositeScalars);
        }
        if (referenceName.equals(CommonReferenceNames.Area.value)) {
            return value.getId();
        }
        if (referenceName.equals(CommonReferenceNames.Iteration.value)) {
            return value.getId();
        }
        return "~squashNone".equals(value.getId()) ? "" : value.getScalar();
    }

    private static String extractWorkItemType(AdvancedIssue advancedIssue) {
        FieldValue value = (FieldValue)advancedIssue.getFieldValues().get(CommonReferenceNames.WorkItemType.value);
        if (value != null) {
            return value.getScalar();
        }
        throw new RuntimeException("Cannot find work item type value.");
    }
}

