/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.conversion;

import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.squashtest.tm.bugtracker.definition.context.ExecutionStepInfo;
import org.squashtest.tm.bugtracker.definition.context.ExecutionSubItemInfo;
import org.squashtest.tm.bugtracker.definition.context.ExploratorySessionNoteInfo;
import org.squashtest.tm.bugtracker.definition.context.KeywordExecutionStepInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.bugtracker.definition.context.ScriptedExecutionStepInfo;
import org.squashtest.tm.bugtracker.definition.context.StandardExecutionStepInfo;
import org.squashtest.tm.bugtracker.definition.context.TestCaseInfo;
import org.squashtest.tm.bugtracker.definition.context.formatter.DefaultRemoteIssueContextFormatter;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.conversion.html.HTMLTextBuilder;

@Service(value="squashtest.bugtracker.azureDevOps.RemoteIssueContextFormatter")
public class RemoteIssueContextFormatter
extends DefaultRemoteIssueContextFormatter {
    public RemoteIssueContextFormatter(MessageSource messageSource) {
        super(messageSource);
    }

    public String buildDescription(RemoteIssueContext context) {
        HTMLTextBuilder builder = new HTMLTextBuilder();
        builder.appendTitle1(this.buildTestCaseTitle(context)).append(builder.createParagraph().appendText(this.buildExecutionInfo(context))).append(builder.createParagraph().appendText(this.buildIssuedStepNumber(context))).appendTitle2(this.getLocaleDescriptionTitleLabel()).append(builder.createParagraph());
        if (context.issueWasReportedInStep()) {
            this.appendStepInformation(context, builder);
        }
        return builder.build();
    }

    protected void appendStepInformation(RemoteIssueContext context, HTMLTextBuilder builder) {
        switch (context.getTestCase().getKind()) {
            case STANDARD: {
                this.appendStandardStepInformation(context, builder);
                break;
            }
            case GHERKIN: {
                this.appendScriptedStepInformation(context, builder);
                break;
            }
            case KEYWORD: {
                this.appendKeywordStepInformation(context, builder);
                break;
            }
            case EXPLORATORY: {
                this.appendExploratorySessionNoteInformation(context, builder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled test case kind " + String.valueOf(context.getTestCase().getKind()));
            }
        }
    }

    private void appendStandardStepInformation(RemoteIssueContext context, HTMLTextBuilder builder) {
        String prerequisite = context.getExecution().getPrerequisite();
        if (StringUtils.isNotEmpty((CharSequence)prerequisite)) {
            builder.appendTitle2(this.getLocalePrerequisite()).append(builder.createParagraph().appendText(context.getExecution().getHtmlPrerequisite()));
        }
        for (ExecutionSubItemInfo step : context.getSubItems()) {
            StandardExecutionStepInfo standardStep = (StandardExecutionStepInfo)step;
            builder.appendTitle2(this.buildCurrentStepNumber(standardStep, context)).appendTitle3(this.getLocaleActionLabel()).append(standardStep.getHtmlAction()).appendTitle3(this.getLocaleExpectedResultLabel()).append(standardStep.getHtmlExpectedResult());
            if (!step.getId().equals(context.getBuggedItemId())) continue;
            break;
        }
    }

    private void appendScriptedStepInformation(RemoteIssueContext context, HTMLTextBuilder builder) {
        Optional optionalStep;
        String prerequisite = context.getExecution().getPrerequisite();
        if (StringUtils.isNotEmpty((CharSequence)prerequisite)) {
            builder.appendTitle2(this.getLocaleTestCaseContext()).append(context.getExecution().getHtmlPrerequisite());
        }
        if ((optionalStep = context.findBuggedStep()).isPresent() && ((ExecutionStepInfo)optionalStep.get()).getTestCaseKind().equals((Object)TestCaseInfo.Kind.GHERKIN)) {
            ScriptedExecutionStepInfo step = (ScriptedExecutionStepInfo)optionalStep.get();
            builder.appendTitle2(this.getLocaleScriptLabel()).append(builder.createParagraph().appendCode(step.getScript()));
        }
    }

    private void appendKeywordStepInformation(RemoteIssueContext context, HTMLTextBuilder builder) {
        String allSteps = context.getSubItems().stream().map(KeywordExecutionStepInfo.class::cast).map(step -> "&nbsp;&nbsp;&nbsp;" + step.getAction()).collect(Collectors.joining("<br>"));
        Optional optionalStep = context.findBuggedStep();
        optionalStep.ifPresent(executionStepInfo -> builder.appendTitle2(this.buildCurrentStepNumber((KeywordExecutionStepInfo)executionStepInfo, context)).appendTitle3(this.getLocaleTestStepsTitleLabel()).append(builder.createParagraph().appendCode(allSteps)).build());
    }

    private void appendExploratorySessionNoteInformation(RemoteIssueContext context, HTMLTextBuilder builder) {
        Object t;
        Optional buggedItem = context.findBuggedItem();
        if (buggedItem.isPresent() && (t = buggedItem.get()) instanceof ExploratorySessionNoteInfo) {
            ExploratorySessionNoteInfo noteInfo = (ExploratorySessionNoteInfo)t;
            builder.append(builder.createParagraph().appendText(noteInfo.getContent()));
        }
    }
}

