/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis.internal.service;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.CredentialHolder;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.MantisClient;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.exception.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Project;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.response.MantisConfigsResponse;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.response.MantisProjectsResponse;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.template.LabelTemplate;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.project.customfields.SchemeBuilder;

@Service(value="squash.tm.plugin.bugtracker.mantis.MantisProjectService")
public class MantisProjectService {
    private final SchemeBuilder schemeBuilder;
    private final ExceptionHandler exceptionHandler;

    public MantisProjectService(SchemeBuilder schemeBuilder, ExceptionHandler exceptionHandler) {
        this.schemeBuilder = schemeBuilder;
        this.exceptionHandler = exceptionHandler;
    }

    public AdvancedProject searchProjectById(String id, CredentialHolder credentialHolder, MantisClient mantisClient) {
        Project project = this.findProjectById(id, credentialHolder, mantisClient);
        return this.convertProjectToAdvancedProject(project, credentialHolder, mantisClient);
    }

    public Project findProjectById(String id, CredentialHolder credentialHolder, MantisClient mantisClient) {
        MantisProjectsResponse projects = mantisClient.findProjectById(id, credentialHolder);
        if (projects.getProjects().isEmpty()) {
            throw this.exceptionHandler.projectNotFound(id);
        }
        return projects.getProjects().get(0);
    }

    public Project findProjectByName(String projectName, CredentialHolder credentialHolder, MantisClient mantisClient) {
        MantisProjectsResponse projects = mantisClient.findAllProjects(credentialHolder);
        List filteredProjects = projects.getProjects().stream().filter(project -> project.getName().equals(projectName)).collect(Collectors.toList());
        if (filteredProjects.isEmpty()) {
            throw this.exceptionHandler.projectNotFound(projectName);
        }
        return (Project)filteredProjects.get(0);
    }

    public AdvancedProject convertProjectToAdvancedProject(Project project, CredentialHolder credentialHolder, MantisClient mantisClient) {
        List<LabelTemplate> severities = this.getAllSeverities(credentialHolder, mantisClient);
        List<LabelTemplate> priorities = this.getAllPriorities(credentialHolder, mantisClient);
        List<LabelTemplate> reproducibilities = this.getAllReproducibilities(credentialHolder, mantisClient);
        return AdvancedProject.create((String)project.getId(), (String)project.getName(), this.schemeBuilder.buildSchemes(project, severities, priorities, reproducibilities));
    }

    private List<LabelTemplate> getAllSeverities(CredentialHolder credentialHolder, MantisClient mantisClient) {
        MantisConfigsResponse mantisConfigsResponse = mantisClient.getSeverities(credentialHolder);
        return mantisConfigsResponse.getFirstMantisConfigValues();
    }

    private List<LabelTemplate> getAllPriorities(CredentialHolder credentialHolder, MantisClient mantisClient) {
        MantisConfigsResponse mantisConfigsResponse = mantisClient.getPriorities(credentialHolder);
        return mantisConfigsResponse.getFirstMantisConfigValues();
    }

    private List<LabelTemplate> getAllReproducibilities(CredentialHolder credentialHolder, MantisClient mantisClient) {
        MantisConfigsResponse mantisConfigsResponse = mantisClient.getReproducibilities(credentialHolder);
        return mantisConfigsResponse.getFirstMantisConfigValues();
    }
}

