/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis;

import jakarta.inject.Provider;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerProviderDescriptor;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.mantis.MantisBugtrackerConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnectorProvider;

@Service(value="squashtest.core.bugtracker.MantisConnectorProvider")
public class MantisBugtrackerConnectorProvider
implements AdvancedBugTrackerConnectorProvider {
    private static final String KIND = "mantis";
    private static final String LABEL = "Mantis Bugtracker REST connector";
    private final Provider<MantisBugtrackerConnector> connectorProvider;

    public MantisBugtrackerConnectorProvider(Provider<MantisBugtrackerConnector> connectorProvider) {
        this.connectorProvider = connectorProvider;
    }

    public String getBugTrackerKind() {
        return KIND;
    }

    public String getLabel() {
        return LABEL;
    }

    public AdvancedBugTrackerConnector createConnector(BugTracker bugTracker) {
        if (bugTracker == null) {
            throw new NullArgumentException("bugTracker");
        }
        MantisBugtrackerConnector connector = (MantisBugtrackerConnector)this.connectorProvider.get();
        connector.setBugtracker(bugTracker);
        return connector;
    }

    public BugTrackerProviderDescriptor getDescriptor() {
        return new BugTrackerProviderDescriptor(){

            public boolean usePathToProjects() {
                return false;
            }
        };
    }
}

