/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators.helper;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.SystemInfoListItemCode;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.exception.sync.SynchronizedFieldException;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementVersionDto;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.plugin.rest.validators.helper.CustomFieldValueValidationHelper;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.plugin.ConfigurablePluginManager;

@Component
public class RequirementVersionDtoValidationHelper
extends CustomFieldValueValidationHelper {
    public static final String CATEGORY = "category";
    public static final String SYNCHRONIZED_FIELD = "synchronized field";
    public static final String UPDATED_BY_SYNCHRO = "can only be updated by synchronization for this requirement.";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementVersionDtoValidationHelper.class);
    @Inject
    private InfoListItemFinderService infoListItemFinderService;
    @Inject
    private CustomFieldValueHelper customFieldValueHelper;
    @Inject
    ConfigurablePluginManager configurablePluginManager;

    public void checkAndAssignValues(Errors errors, RequirementVersionDto iRequirementVersion) {
        this.checkAndAssignDescription(errors, iRequirementVersion);
        this.checkAndAssignReference(errors, iRequirementVersion);
        this.checkAndAssignCategory(errors, iRequirementVersion);
        this.checkAndAssignCriticality(errors, iRequirementVersion);
    }

    public void checkAndAssignValuesPatch(Errors errors, RequirementVersionDto iRequirementVersion, Requirement requirement) {
        if (iRequirementVersion.isHasName()) {
            this.checkAndAssignName(errors, requirement);
        }
        if (iRequirementVersion.isHasReference()) {
            this.checkAndAssignReference(errors, iRequirementVersion);
        }
        if (iRequirementVersion.isHasDescription()) {
            this.checkAndAssignDescription(errors, iRequirementVersion);
        }
        if (iRequirementVersion.isHasCategory()) {
            this.checkAndAssignCategory(errors, iRequirementVersion);
        }
        if (iRequirementVersion.isHasCriticality()) {
            this.checkAndAssignCriticality(errors, iRequirementVersion);
        }
        if (iRequirementVersion.isHasStatus()) {
            this.checkAndAssignStatus(errors, iRequirementVersion, requirement);
        }
    }

    private void checkAndAssignName(Errors errors, Requirement requirement) {
        if (requirement.isSynchronized()) {
            errors.rejectValue("name", SYNCHRONIZED_FIELD, "Name cannot be updated because the requirement is synchronized.");
            return;
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
    }

    private void checkAndAssignDescription(Errors errors, RequirementVersionDto iRequirementVersion) {
        if (this.isFieldSynchronized(errors, iRequirementVersion.getId(), "DESCRIPTION")) {
            return;
        }
        if (iRequirementVersion.getDescription() == null) {
            iRequirementVersion.setDescription("");
        }
    }

    private void checkAndAssignReference(Errors errors, RequirementVersionDto iRequirementVersion) {
        if (this.isFieldSynchronized(errors, iRequirementVersion.getId(), "REFERENCE")) {
            return;
        }
        if (iRequirementVersion.getReference() == null) {
            iRequirementVersion.setReference("");
        }
    }

    private void checkAndAssignCriticality(Errors errors, RequirementVersionDto iRequirementVersion) {
        RequirementCriticality criticality = iRequirementVersion.getCriticality();
        if (this.isFieldSynchronized(errors, iRequirementVersion.getId(), "CRITICALITY")) {
            return;
        }
        if (criticality == null) {
            iRequirementVersion.setCriticality(RequirementCriticality.UNDEFINED);
        }
    }

    private void checkAndAssignCategory(Errors errors, RequirementVersionDto iRequirementVersion) {
        InfoListItem category = iRequirementVersion.getCategory();
        if (this.isFieldSynchronized(errors, iRequirementVersion.getId(), CATEGORY)) {
            return;
        }
        if (category != null) {
            String code = category.getCode();
            Long projectId = iRequirementVersion.getProjectId();
            if (projectId == null) {
                errors.rejectValue(CATEGORY, "invalid projetId", "You must give a project to a Rest Node to be able to check infolist.");
            }
            if (this.infoListItemFinderService.isCategoryConsistent(projectId.longValue(), code)) {
                iRequirementVersion.setCategory(this.infoListItemFinderService.findByCode(code));
            } else {
                errors.rejectValue(CATEGORY, "invalid category", "Invalid requirement category for this project");
            }
        } else {
            InfoListItem defaultCategory = this.infoListItemFinderService.findByCode(SystemInfoListItemCode.CAT_UNDEFINED.getCode());
            iRequirementVersion.setCategory(defaultCategory);
        }
    }

    public void checkAndAssignStatus(Errors errors, RequirementVersionDto requirementVersionDto, Requirement requirement) {
        RequirementStatus actualStatus = requirement.getStatus();
        RequirementStatus reqVersionStatus = requirementVersionDto.getStatus();
        if (this.isFieldSynchronized(errors, requirementVersionDto.getId(), "STATUS")) {
            return;
        }
        if (reqVersionStatus == null) {
            requirementVersionDto.setStatus(RequirementStatus.WORK_IN_PROGRESS);
        }
        if (!actualStatus.getAllowsStatusUpdate() || !actualStatus.isTransitionLegal(reqVersionStatus)) {
            errors.rejectValue("status", "invalid status", "Only requirements which have the status 'Under review' can have their status updated to 'Approved'.");
        }
    }

    private boolean isFieldSynchronized(Errors errors, Long reqVersionId, String fieldName) {
        if (Objects.nonNull(reqVersionId)) {
            try {
                this.configurablePluginManager.checkIfFieldIsSynchronized(reqVersionId, fieldName.toUpperCase());
            }
            catch (SynchronizedFieldException e) {
                LOGGER.info("The {} field from requirement version {} {}", new Object[]{fieldName, reqVersionId, UPDATED_BY_SYNCHRO, e});
                String message = String.format("The %s field %s", fieldName.toLowerCase(), UPDATED_BY_SYNCHRO);
                errors.rejectValue(fieldName.toLowerCase(), SYNCHRONIZED_FIELD, message);
                return true;
            }
        }
        return false;
    }

    public void checkCufs(Errors errors, RequirementVersionDto requirementVersionDto) {
        List<CustomFieldValueDto> listCufsDto = requirementVersionDto.getCustomFields();
        this.customFieldValueHelper.checkCufs(errors, BindableEntity.REQUIREMENT_VERSION, requirementVersionDto.getProjectId(), listCufsDto, requirementVersionDto.getId());
    }
}

