/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.IterationTestPlanItemDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestSuiteDto;
import org.squashtest.tm.plugin.rest.repository.RestIterationTestPlanItemRepository;
import org.squashtest.tm.plugin.rest.repository.RestTestSuiteRepository;
import org.squashtest.tm.plugin.rest.service.RestTestSuiteService;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;
import org.squashtest.tm.service.campaign.TestSuiteTestPlanManagerService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class RestTestSuiteServiceImpl
implements RestTestSuiteService {
    @Inject
    private RestTestSuiteRepository testSuiteRepository;
    @Inject
    private RestIterationTestPlanItemRepository itpiRepository;
    @Inject
    private CustomIterationModificationService customIterationModificationService;
    @Inject
    private TestSuiteTestPlanManagerService testSuiteTestPlanManagerService;
    @Inject
    private CustomFieldValueHelper customFieldValueHelper;
    @Inject
    private TestSuiteDao testSuiteDao;
    @Inject
    private CampaignNodeDeletionHandler campaignNodeDeletionHandler;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private DSLContext dslContext;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.campaign.TestSuite','READ')")
    public TestSuite getOne(long id) {
        return (TestSuite)this.testSuiteRepository.getReferenceById(id);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#testSuiteId,'org.squashtest.tm.domain.campaign.TestSuite','READ')")
    public Page<TestPlanItem> findTestPlan(long testSuiteId, Pageable pageable) {
        return this.itpiRepository.findAllByTestSuiteId(testSuiteId, pageable);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#iterationId,'org.squashtest.tm.domain.campaign.Iteration','WRITE')")
    public TestSuite addTestSuite(Long iterationId, TestSuiteDto testSuiteDto) {
        TestSuite testSuite = new TestSuite();
        testSuite.setName(testSuiteDto.getName());
        if (testSuiteDto.isHasDescription()) {
            testSuite.setDescription(testSuiteDto.getDescription());
        }
        this.customIterationModificationService.addTestSuite(iterationId.longValue(), testSuite);
        if (testSuiteDto.isHasListItpi()) {
            List listIdsItem = testSuiteDto.getListItpi().stream().map(IterationTestPlanItemDto::getId).collect(Collectors.toList());
            this.testSuiteTestPlanManagerService.bindTestPlanToMultipleSuites(List.of(testSuite.getId()), listIdsItem);
        }
        if (testSuiteDto.isHasCufs()) {
            List<CustomFieldValueDto> cufValuesDto = testSuiteDto.getCustomFields();
            this.customFieldValueHelper.patchCustomFieldValue((BoundEntity)testSuite, cufValuesDto);
        }
        return testSuite;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#testSuiteId,'org.squashtest.tm.domain.campaign.TestSuite','WRITE')")
    public TestSuite modifyTestSuite(TestSuiteDto testSuiteDto, Long testSuiteId) {
        TestSuite testSuite = this.testSuiteTestPlanManagerService.findTestSuite(testSuiteId.longValue());
        if (testSuiteDto.isHasDescription()) {
            testSuite.setDescription(testSuiteDto.getDescription());
        }
        if (testSuiteDto.isHasStatus()) {
            ExecutionStatus executionStatus = ExecutionStatus.valueOf((String)testSuiteDto.getStatus());
            testSuite.setExecutionStatus(executionStatus);
        }
        if (testSuiteDto.isHasCufs()) {
            List<CustomFieldValueDto> cufValuesDto = testSuiteDto.getCustomFields();
            this.customFieldValueHelper.patchCustomFieldValue((BoundEntity)testSuite, cufValuesDto);
        }
        return testSuite;
    }

    @Override
    public void deleteTestSuite(List<Long> testSuiteIds) {
        this.permissionService.checkPermission(testSuiteIds, Permissions.DELETE.name(), TestSuite.class.getName());
        this.campaignNodeDeletionHandler.deleteSuites(testSuiteIds, false);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#testSuiteId,'org.squashtest.tm.domain.campaign.TestSuite','LINK')")
    public TestSuite detachTestPlanFromTestSuite(Long testSuiteId, List<Long> ids) {
        TestSuite testSuite = (TestSuite)this.testSuiteDao.getReferenceById((Object)testSuiteId);
        this.testSuiteTestPlanManagerService.detachTestPlanFromTestSuite(ids, testSuiteId.longValue());
        return testSuite;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#testSuiteId,'org.squashtest.tm.domain.campaign.TestSuite','LINK')")
    public TestSuite attachTestPlanToTestSuite(Long testSuiteId, List<Long> ids) {
        TestSuite testSuite = (TestSuite)this.testSuiteDao.getReferenceById((Object)testSuiteId);
        this.testSuiteTestPlanManagerService.bindTestPlanToMultipleSuites(List.of(testSuite.getId()), ids);
        return testSuite;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#testSuiteId,'org.squashtest.tm.domain.campaign.TestSuite','READ')")
    public List<Long> getExecutionIdsByTestSuite(Long testSuiteId) {
        return this.dslContext.select((SelectField)Tables.EXECUTION.EXECUTION_ID).from((TableLike)Tables.EXECUTION).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).join((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)testSuiteId)).fetchInto(Long.class);
    }

    @Override
    public TestPlanStatistics getTestSuiteStatisticsByTestSuiteIds(Long testSuiteId) {
        return this.testSuiteDao.getTestSuiteStatistics(testSuiteId.longValue());
    }
}

