/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.plugin.rest.jackson.model.ExecutionAndCustomFields;
import org.squashtest.tm.plugin.rest.repository.RestExecutionRepository;
import org.squashtest.tm.plugin.rest.repository.RestExecutionStepRepository;
import org.squashtest.tm.plugin.rest.service.RestExecutionService;
import org.squashtest.tm.plugin.rest.service.RestInternalCustomFieldValueUpdaterService;
import org.squashtest.tm.service.execution.ExecutionDeletionService;

@Service
@Transactional
public class RestExecutionServiceImpl
implements RestExecutionService {
    @Inject
    private RestExecutionRepository executionRepository;
    @Inject
    private RestExecutionStepRepository executionStepRepository;
    @Inject
    private RestInternalCustomFieldValueUpdaterService internalCufService;
    @Inject
    private ExecutionDeletionService executionDeletionService;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.execution.Execution' , 'READ')")
    public Execution getOne(long id) {
        Execution execution = (Execution)this.executionRepository.getReferenceById(id);
        return execution;
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#executionId,'org.squashtest.tm.domain.execution.Execution' , 'READ')")
    public Page<ExecutionStep> findExecutionSteps(long executionId, Pageable pageable) {
        Execution execution = this.getOne(executionId);
        return this.executionStepRepository.findAllByExecution(execution, pageable);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#exec.wrapped , 'EXECUTE')")
    public void updateExecution(ExecutionAndCustomFields exec) {
        this.internalCufService.mergeCustomFields(exec);
    }

    @Override
    public void deleteExecution(Long execId) {
        this.executionDeletionService.deleteExecutions(List.of(execId));
    }
}

