/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.repository;

import java.util.Collection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;

@Repository
public interface RestTestCaseRepository
extends JpaRepository<TestCase, Long> {
    @Query(value="from TestCase tc where tc.project.id in (:projectIds)")
    public Page<TestCase> findAllInProjects(@Param(value="projectIds") Collection<Long> var1, Pageable var2);

    @Query(value="select steps from TestCase tc join tc.steps steps where tc.id = :tcid order by index(steps)")
    public Page<TestStep> findTestCaseSteps(@Param(value="tcid") long var1, Pageable var3);

    @Query(value="select tc from TestCase tc left join fetch tc.parameters left join fetch tc.datasets left join fetch tc.requirementVersionCoverages left join fetch tc.steps left join fetch tc.attachmentList list left join fetch list.attachments where tc.id = :id")
    public TestCase retrieveById(@Param(value="id") Long var1);

    @Query(value="select distinct tc\nfrom TestCase tc\nleft join ScriptedTestCase stc on stc.id = tc.id\nleft join KeywordTestCase ktc on ktc.id = tc.id\nleft join ExploratoryTestCase etc on etc.id = tc.id\nwhere tc.project.id in (:projectIds)\n  and stc.id is null\n  and ktc.id is null\n  and etc.id is null")
    public Page<TestCase> findAllStandardTestCasesInProject(@Param(value="projectIds") Collection<Long> var1, Pageable var2);

    @Query(value="select distinct tc from TestCase tc inner join ScriptedTestCase stc on stc.id = tc.id where tc.project.id in (:projectIds)")
    public Page<TestCase> findAllScriptedTestCasesInProject(@Param(value="projectIds") Collection<Long> var1, Pageable var2);

    @Query(value="select distinct tc from TestCase tc inner join KeywordTestCase ktc on ktc.id = tc.id where tc.project.id in (:projectIds)")
    public Page<TestCase> findAllKeywordTestCasesInProject(@Param(value="projectIds") Collection<Long> var1, Pageable var2);

    @Query(value="select distinct tc from TestCase tc inner join ExploratoryTestCase etc on etc.id = tc.id where tc.project.id in (:projectIds)")
    public Page<TestCase> findAllExploratoryTestCasesInProject(@Param(value="projectIds") Collection<Long> var1, Pageable var2);
}

