/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.model;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.domain.users.UsersGroup;
import org.squashtest.tm.plugin.rest.jackson.model.PartyDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.TeamDto;
import org.squashtest.tm.plugin.rest.jackson.model.UserDto;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=UserDto.class, name="user"), @JsonSubTypes.Type(value=TeamDto.class, name="team")})
public abstract class PartyDto {
    private Long id;
    private UsersGroup group;
    private List<PartyPreference> preferences;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UsersGroup getGroup() {
        return this.group;
    }

    public void setGroup(UsersGroup group) {
        this.group = group;
    }

    public List<PartyPreference> getPreferences() {
        return this.preferences;
    }

    public void setPreferences(List<PartyPreference> preferences) {
        this.preferences = preferences;
    }

    public abstract void accept(PartyDtoVisitor var1);

    public static Party convertDto(PartyDto dto) {
        final Party[] parties = new Party[1];
        PartyDtoVisitor visitor = new PartyDtoVisitor(){

            @Override
            public void visit(UserDto userDto) {
                User user = new User();
                user.setGroup(userDto.getGroup());
                parties[0] = user;
            }

            @Override
            public void visit(TeamDto teamDto) {
                Team team = new Team();
                team.setGroup(teamDto.getGroup());
                parties[0] = team;
            }
        };
        dto.accept(visitor);
        return parties[0];
    }
}

