/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import com.google.common.base.CaseFormat;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortDefault;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.BasicResourceAssembler;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusion;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.ProjectTypeFilter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyClearance;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyPermission;
import org.squashtest.tm.plugin.rest.service.RestAclService;
import org.squashtest.tm.plugin.rest.service.RestPartyService;
import org.squashtest.tm.plugin.rest.service.RestProjectService;
import org.squashtest.tm.plugin.rest.validators.GenericProjectPostValidator;

@RestApiController(value=GenericProject.class)
@UseDefaultRestApiConfiguration
public class RestProjectController
extends BaseRestController {
    @Inject
    private RestProjectService service;
    @Inject
    private RestAclService aclService;
    @Inject
    private RestPartyService partyService;
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private GenericProjectPostValidator genericProjectPostValidator;
    @Inject
    private BasicResourceAssembler resAssembler;

    @GetMapping(value={"/projects/{id}"})
    @EntityGetter(value={Project.class, ProjectTemplate.class})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<GenericProject>> findProject(@PathVariable(value="id") long projectId) {
        GenericProject project = this.service.getOne(projectId);
        EntityModel res = this.toEntityModel((Identified)project);
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectController)((Object)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findRequirementLibraryContent(projectId, null, null))).withRel("requirements"));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectController)((Object)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findTestCaseLibraryContent(projectId, null, null))).withRel("test-cases"));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectController)((Object)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findCampaignLibraryContent(projectId, null, null))).withRel("campaigns"));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectController)((Object)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findPartyClearancesByProject(projectId))).withRel("clearances"));
        res.add(this.createRelationTo("attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/projects"}, params={"projectName"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<GenericProject>> findProjectByName(@RequestParam(value="projectName") String projectName) {
        GenericProject project = this.service.getOneByName(projectName);
        EntityModel res = this.toEntityModel((Identified)project);
        long projectId = project.getId();
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectController)((Object)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findRequirementLibraryContent(projectId, null, null))).withRel("requirements"));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectController)((Object)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findTestCaseLibraryContent(projectId, null, null))).withRel("test-cases"));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectController)((Object)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findCampaignLibraryContent(projectId, null, null))).withRel("campaigns"));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectController)((Object)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findPartyClearancesByProject(projectId))).withRel("clearances"));
        res.add(this.createRelationTo("attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/projects"})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<PagedModel<EntityModel<GenericProject>>> findAllReadableProjects(Pageable pageable, ProjectTypeFilter type) {
        Page<GenericProject> projects = switch (type) {
            case ProjectTypeFilter.STANDARD -> this.service.findAllReadableStandardProject(pageable);
            case ProjectTypeFilter.TEMPLATE -> this.service.findAllReadableProjectTemplate(pageable);
            default -> this.service.findAllReadable(pageable);
        };
        PagedModel res = this.toPagedModel(projects);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/projects"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<GenericProject>> createGenericProject(@RequestBody GenericProjectDto genericProjectDto) throws BindException {
        this.validatePostGenericProject(genericProjectDto);
        GenericProject genericProject = this.service.createGenericProject(genericProjectDto);
        EntityModel res = this.toEntityModel((Identified)genericProject);
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectController)((Object)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findRequirementLibraryContent(genericProject.getId(), null, null))).withRel("requirements"));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectController)((Object)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findTestCaseLibraryContent(genericProject.getId(), null, null))).withRel("test-cases"));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectController)((Object)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0]))).findCampaignLibraryContent(genericProject.getId(), null, null))).withRel("campaigns"));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @GetMapping(value={"/projects/{id}/requirements-library/content"})
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedModel<EntityModel<RequirementLibraryNode<Resource>>>> findRequirementLibraryContent(@PathVariable(value="id") long projectId, Pageable paging, ContentInclusion include) {
        Page<RequirementLibraryNode<Resource>> nodes = null;
        switch (include) {
            case NESTED: {
                nodes = this.service.findRequirementLibraryAllContent(projectId, paging);
                break;
            }
            default: {
                nodes = this.service.findRequirementLibraryRootContent(projectId, paging);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(nodes, "requirement-library-content");
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/projects/{id}/reporting-library/content"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<PagedModel<EntityModel<CustomReportLibraryNode>>> findCustomReportLibraryContent(@PathVariable(value="id") long projectId, Pageable paging, ContentInclusion include) {
        Page<CustomReportLibraryNode> nodes = null;
        switch (include) {
            case NESTED: {
                nodes = this.service.findCustomReportLibraryAllContent(projectId, paging);
                break;
            }
            default: {
                nodes = this.service.findCustomReportLibraryRootContent(projectId, paging);
            }
        }
        SingleRelPagedResources<EntityModel<CustomReportLibraryNode>> res = this.toPagedResourcesForCustomReportLibrary(nodes, "reporting-library-content");
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/projects/{id}/requirements"})
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedModel<EntityModel<Requirement>>> findRequirementsByProject(@PathVariable(value="id") long projectId, Pageable paging) {
        Page<Requirement> reqs = this.service.findRequirementsByProject(projectId, paging);
        PagedModel res = this.toPagedModel(reqs);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/projects/{id}/test-cases-library/content"})
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedModel<EntityModel<TestCaseLibraryNode>>> findTestCaseLibraryContent(@PathVariable(value="id") long projectId, @SortDefault(sort={"nodes.id"}, direction=Sort.Direction.ASC) Pageable paging, ContentInclusion include) {
        Page<TestCaseLibraryNode> nodes = null;
        switch (include) {
            case NESTED: {
                nodes = this.service.findTestCaseLibraryAllContent(projectId, paging);
                break;
            }
            default: {
                nodes = this.service.findTestCaseLibraryRootContent(projectId, paging);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(nodes, "test-case-library-content");
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/projects/{id}/test-cases"})
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedModel<EntityModel<TestCase>>> findTestCasesByProject(@PathVariable(value="id") long projectId, Pageable paging, @RequestParam(value="fields", required=false) String fields) {
        Page<TestCase> testCases = this.service.findTestCasesByProject(projectId, paging, this.getFields(fields));
        SingleRelPagedResources res = this.toPagedResourcesWithRel(testCases, "test-cases");
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/projects/{id}/campaigns-library/content"})
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedModel<EntityModel<CampaignLibraryNode>>> findCampaignLibraryContent(@PathVariable(value="id") long projectId, @SortDefault(sort={"nodes.id"}, direction=Sort.Direction.ASC) Pageable paging, ContentInclusion include) {
        Page<CampaignLibraryNode> nodes = null;
        switch (include) {
            case NESTED: {
                nodes = this.service.findCampaignLibraryAllContent(projectId, paging);
                break;
            }
            default: {
                nodes = this.service.findCampaignLibraryRootContent(projectId, paging);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(nodes, "campaign-library-content");
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/projects/{id}/campaigns"})
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedModel<EntityModel<Campaign>>> findCampaignsByProject(@PathVariable(value="id") long projectId, Pageable paging) {
        Page<Campaign> testCases = this.service.findCampaignsByProject(projectId, paging);
        PagedModel res = this.toPagedModel(testCases);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/projects/{id}/clearances"})
    @DynamicFilterExpression(value="login, name")
    public ResponseEntity<EntityModel<RestPartyClearance>> findPartyClearancesByProject(@PathVariable(value="id") long projectId) {
        RestPartyClearance partyClearances = this.service.findAllClearancesByProjectId(projectId);
        EntityModel res = EntityModel.of((Object)partyClearances);
        this.linksHelper.addAllLinksForPartyClearance(projectId, (EntityModel<RestPartyClearance>)res);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/projects/{id}/permissions"})
    @DynamicFilterExpression(value="login, name")
    public ResponseEntity<EntityModel<RestPartyPermission>> findPartyPermissionsByProject(@PathVariable(value="id") long projectId) {
        RestPartyPermission partyPermissions = this.service.findAllPermissionsByProjectId(projectId);
        EntityModel res = EntityModel.of((Object)partyPermissions);
        this.linksHelper.addAllLinksForPartyPermission(projectId, (EntityModel<RestPartyPermission>)res);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/projects/{projectId}/clearances/{profileId}/users/{partyIds}"})
    @DynamicFilterExpression(value="login, name")
    public ResponseEntity<EntityModel<RestPartyClearance>> postNewClearanceToProjectWithPartyIds(@PathVariable(value="projectId") long projectId, @PathVariable(value="profileId") long profileId, @PathVariable(value="partyIds") List<Long> partyIds) {
        for (Long partyId : partyIds) {
            this.service.addNewPermissionToProject((long)partyId, projectId, profileId);
        }
        RestPartyClearance partyClearances = this.service.buildPartyClearanceDataModel(profileId, partyIds);
        EntityModel res = EntityModel.of((Object)partyClearances);
        this.linksHelper.addAllLinksForPartyClearance(projectId, (EntityModel<RestPartyClearance>)res);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/projects/{projectId}/permissions/{permissionGroup}"})
    @DynamicFilterExpression(value="login, name")
    public ResponseEntity<EntityModel<RestPartyPermission>> postNewPermissionToProjectWithPartyIds(@PathVariable(value="projectId") long projectId, @PathVariable(value="permissionGroup") String permissionGroup, @RequestParam(value="ids") List<Long> partyIds) throws BindException {
        PostProjectPermissionModel bean = new PostProjectPermissionModel(partyIds, permissionGroup);
        this.validatePostNewPermissionsToProject(bean);
        for (Long partyId : bean.partyIds) {
            this.service.addNewPermissionToProject((long)partyId, projectId, bean.permissionGroup);
        }
        RestPartyPermission partyPermissions = this.service.buildPartyPermissionDataModel(permissionGroup, partyIds);
        EntityModel res = EntityModel.of((Object)partyPermissions);
        this.linksHelper.addAllLinksForPartyPermission(projectId, (EntityModel<RestPartyPermission>)res);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/projects/{projectId}/users/{partyIds}"})
    public ResponseEntity<Void> removePartyFromProject(@PathVariable(value="projectId") long projectId, @PathVariable(value="partyIds") List<Long> partyIds) throws BindException {
        RemoveProjectPartyModel bean = new RemoveProjectPartyModel(partyIds);
        this.validateRemovePartyFromProject(bean);
        for (Long partyId : bean.partyIds) {
            this.service.deletePartyFromProject(partyId, projectId);
        }
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/refresh-acl-cache"})
    public ResponseEntity<Void> refreshAclCache() {
        this.aclService.refreshAclCache();
        return ResponseEntity.noContent().build();
    }

    private void validateRemovePartyFromProject(RemoveProjectPartyModel bean) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        List<Long> partyIds = bean.partyIds;
        int i = 0;
        while (i < partyIds.size()) {
            Long partyId = partyIds.get(i);
            Party party = this.partyService.findById(partyId);
            if (party == null) {
                String fieldName = "partyIds[" + i + "]";
                String message = "No id of user or team known for " + String.valueOf(partyId);
                BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)bean, "remove-project-party");
                validation.rejectValue(fieldName, "invalid ids for user or team", message);
                errors.add((Errors)validation);
            }
            ++i;
        }
        ErrorHandlerHelper.throwIfError(bean, errors, "remove-project-party");
    }

    private void validatePostGenericProject(GenericProjectDto genericProjectDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)genericProjectDto, "post-generic-project");
        this.genericProjectPostValidator.validate(genericProjectDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(genericProjectDto, errors, "post-generic-project");
    }

    private void validatePostNewPermissionsToProject(PostProjectPermissionModel bean) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)bean, "post-project-permission");
        int index = 0;
        for (Long partyId : bean.partyIds) {
            Party party = this.partyService.getOne(partyId);
            if (party == null) {
                String message = String.format("No id of user or team known for %d", partyId);
                String fieldName = String.format("partyIds[%d]", index);
                validation.rejectValue(fieldName, "invalid ids for user or team", message);
                errors.add((Errors)validation);
                validation = new BeanPropertyBindingResult((Object)bean, "post-project-permission");
            }
            ++index;
        }
        String rawData = bean.permissionGroup;
        if ("advanced_tester".equals(bean.permissionGroup)) {
            bean.permissionGroup = "advance_tester";
        }
        bean.permissionGroup = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, bean.permissionGroup);
        if (!this.getAllPermissionGroups().contains(bean.permissionGroup)) {
            String message = String.format("No permission group known for %s", rawData);
            validation.rejectValue("permissionGroup", "invalid permission group", message);
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(bean, errors, "post-project-permission");
    }

    private List<String> getAllPermissionGroups() {
        List<AclGroup> groups = this.service.findAllPossiblePermission();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (AclGroup group : groups) {
            groupNames.add(group.getSimpleName());
        }
        return groupNames;
    }

    private <T> SingleRelPagedResources<EntityModel<T>> toPagedResourcesForCustomReportLibrary(Page<T> page, String rel) {
        PagedModel res = this.pageAssembler.toModel(page, (RepresentationModelAssembler)this.resAssembler);
        for (EntityModel entityModel : res.getContent()) {
            String entityType = this.service.toKebabCase(((CustomReportLibraryNode)entityModel.getContent()).getEntityType().getTypeName()) + "s";
            this.service.replaceLinksByCustomSelfLinks(entityModel, entityType);
        }
        return new SingleRelPagedResources(res, rel);
    }

    private class PostProjectPermissionModel {
        private List<Long> partyIds;
        private String permissionGroup;

        private PostProjectPermissionModel(List<Long> partyIds, String permissionGroup) {
            this.partyIds = partyIds;
            this.permissionGroup = permissionGroup;
        }

        public List<Long> getPartyIds() {
            return this.partyIds;
        }

        public String getPermissionGroup() {
            return this.permissionGroup;
        }
    }

    private class RemoveProjectPartyModel {
        private List<Long> partyIds;

        public RemoveProjectPartyModel(List<Long> partyIds) {
            this.partyIds = partyIds;
        }

        public List<Long> getPartyIds() {
            return this.partyIds;
        }
    }
}

