/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.com.atlassian.jira.rest.client.api.domain.input;

import com.google.common.collect.ImmutableList;
import java.util.List;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.AuditAssociatedItem;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.AuditChangedValue;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.AuditRecordInput;
import workflowautomjira.javax.annotation.Nonnull;
import workflowautomjira.javax.annotation.Nullable;

public class AuditRecordBuilder {
    String category;
    String summary;
    AuditAssociatedItem objectItem;
    List<AuditChangedValue> values;
    List<AuditAssociatedItem> associatedItems;

    public AuditRecordBuilder(String category, String summary) {
        this.category = category;
        this.summary = summary;
    }

    public AuditRecordBuilder setObject(AuditAssociatedItem objectItem) {
        this.objectItem = objectItem;
        return this;
    }

    public AuditRecordBuilder setObject(@Nullable String id, String name, String typeName) {
        this.objectItem = new AuditAssociatedItem(id, name, typeName, null, null);
        return this;
    }

    public AuditRecordBuilder setChangedValues(Iterable<AuditChangedValue> values) {
        this.values = ImmutableList.copyOf(values);
        return this;
    }

    public AuditRecordBuilder setAssociatedItems(Iterable<AuditAssociatedItem> associatedItems) {
        this.associatedItems = ImmutableList.copyOf(associatedItems);
        return this;
    }

    @Nonnull
    public AuditRecordInput build() {
        return new AuditRecordInput(this.category, this.summary, this.objectItem, this.associatedItems, this.values);
    }
}

