/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.plugin.redminereq.domain.FilterBinding;
import org.squashtest.tm.plugin.redminereq.service.ValueMappings;

public class EffectiveConfiguration {
    private Long serverId = 0L;
    private Collection<FilterBinding> filterBindings = new HashSet<FilterBinding>();
    private Map<String, EffectiveMapping> fieldMappings = new HashMap<String, EffectiveMapping>();
    private ValueMappings valueMappings = new ValueMappings();

    public Long getServerId() {
        return this.serverId;
    }

    public void setServerId(Long serverId) {
        this.serverId = serverId;
    }

    public Collection<FilterBinding> getFilterBindings() {
        return this.filterBindings;
    }

    public void setFilterBindings(Collection<FilterBinding> filterBindings) {
        this.filterBindings = filterBindings;
    }

    public Map<String, EffectiveMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(Map<String, EffectiveMapping> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public void addEffectiveMapping(String squashField, String redmineField, boolean isCustom) {
        this.fieldMappings.put(squashField, new EffectiveMapping(squashField, redmineField, isCustom));
    }

    public void setValueMappings(ValueMappings valueMappings) {
        this.valueMappings = valueMappings;
    }

    public ValueMappings getValueMappings() {
        return this.valueMappings;
    }

    public boolean hasCustomFields() {
        for (EffectiveMapping e : this.fieldMappings.values()) {
            if (e == null || !e.isCustom()) continue;
            return true;
        }
        return false;
    }

    public Set<String> getQueryFields() {
        HashSet<String> fields = new HashSet<String>();
        for (EffectiveMapping m : this.fieldMappings.values()) {
            if (m.invalid()) continue;
            fields.add(m.getRedmineField());
        }
        return fields;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ \n");
        builder.append("\tserver : ").append(this.serverId).append(",\n");
        builder.append("\tfilters : [\n");
        for (FilterBinding b : this.filterBindings) {
            builder.append("\t\t").append(b.toString()).append(",\n");
        }
        builder.append("\t]\n");
        builder.append("\tfields : [\n");
        for (EffectiveMapping m : this.fieldMappings.values()) {
            builder.append("\t\t").append(m.toString()).append(",\n");
        }
        builder.append("\t]");
        builder.append("\n}");
        return builder.toString();
    }

    public boolean hasSomeRedminefieldsNotfound() {
        for (EffectiveMapping m : this.fieldMappings.values()) {
            if (!m.invalid()) continue;
            return true;
        }
        return false;
    }

    public static final class EffectiveMapping {
        private String squashField;
        private String redmineField;
        private boolean isCustom;
        private String type;
        private String items;

        public EffectiveMapping() {
        }

        public EffectiveMapping(String squashField, String redmineField, boolean isCustom) {
            this.squashField = squashField;
            this.redmineField = redmineField;
            this.isCustom = isCustom;
        }

        public String getSquashField() {
            return this.squashField;
        }

        public void setSquashField(String squashField) {
            this.squashField = squashField;
        }

        public String getRedmineField() {
            return this.redmineField;
        }

        public void setRedmineField(String redmineField) {
            this.redmineField = redmineField;
        }

        public boolean isCustom() {
            return this.isCustom;
        }

        public boolean isNative() {
            return !this.isCustom;
        }

        public void setCustom(boolean isCustom) {
            this.isCustom = isCustom;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getItems() {
            return this.items;
        }

        public void setItems(String items) {
            this.items = items;
        }

        public boolean invalid() {
            return this.redmineField == null;
        }

        public void addCustomInfos(String type, String items) {
            this.type = type;
            this.items = items;
        }

        public String toString() {
            String tostr;
            if (this.invalid()) {
                tostr = "{ " + this.squashField + " : (not found - invalid) }";
            } else {
                String detail = !this.isCustom ? "native" : "custom, type : '" + this.type + "', items : '" + this.items + "'";
                tostr = "{ " + this.squashField + " : " + this.redmineField + " (" + detail + ") }";
            }
            return tostr;
        }
    }
}

