/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.service;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.plugin.redminereq.domain.Configuration;
import org.squashtest.tm.plugin.redminereq.domain.FieldLink;
import org.squashtest.tm.plugin.redminereq.domain.FieldMapping;
import org.squashtest.tm.plugin.redminereq.domain.FilterBinding;
import org.squashtest.tm.plugin.redminereq.exceptions.LocaleConfigurationException;
import org.squashtest.tm.plugin.redminereq.helpers.ValueMappingsYamlDeserializer;
import org.squashtest.tm.plugin.redminereq.service.PluginDao;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Service(value="squash.tm.plugin.redminereq.configurationService")
@Transactional
public class ConfigurationService {
    @Inject
    private PluginDao dao;
    @Inject
    ValueMappingsYamlDeserializer valueMappingsYamlDeserializer;
    @Inject
    private InternationalizationHelper inHelper;

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public Configuration getConfigurationForProject(long projectId) {
        return this.dao.getConfigurationForProject(projectId);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void storeConfigurationForProject(Long projectId, Configuration config) {
        this.dao.storeConfigurationForProject(projectId, config);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void setServerId(Long projectId, Long serverId) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setServerId(serverId);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeOptions(Long projectId, Boolean allowToDeleteReq) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setAllowToDeleteReq(allowToDeleteReq);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void addFilter(Long projectId, FilterBinding filter) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        if (conf.hasFilterBinding(filter)) {
            throw new LocaleConfigurationException(this.inHelper.internationalize("henix.redminereq.filters.dialog.add.nonunique", LocaleContextHolder.getLocale()));
        }
        conf.addFilterBinding(filter);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    private void removeFilters(Long projectId, Collection<FilterBinding> toremove) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        for (FilterBinding f : toremove) {
            conf.removeFilterBinding(f);
        }
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void removeFiltersById(Long projectId, Collection<String> filterIds) {
        HashSet<FilterBinding> toremove = new HashSet<FilterBinding>();
        for (String id : filterIds) {
            FilterBinding filter = FilterBinding.byId(id);
            toremove.add(filter);
        }
        this.removeFilters(projectId, toremove);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public String updateFilterKey(Long projectId, String filterId, String newKey) {
        newKey = StringUtils.trim((String)newKey);
        this.modifyFilterAttribute(projectId, filterId, newKey, FilterBinding::setKey);
        return newKey;
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public String updateFilterFilter(Long projectId, String filterId, String newFilter) {
        newFilter = StringUtils.trim((String)newFilter);
        this.modifyFilterAttribute(projectId, filterId, newFilter, FilterBinding::setFilter);
        return newFilter;
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public String updateFilterPath(Long projectId, String filterId, String newPath) {
        newPath = StringUtils.trim((String)newPath);
        this.modifyFilterAttribute(projectId, filterId, newPath, FilterBinding::setPath);
        return newPath;
    }

    private void modifyFilterAttribute(Long projectId, String filterId, String newValue, AttributeModifier action) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        FilterBinding filter = conf.removeFilterBinding(filterId);
        if (filter == null) {
            throw new LocaleConfigurationException(this.inHelper.internationalize("henix.redminereq.filters.dialog.add.pathinvalid", LocaleContextHolder.getLocale()));
        }
        action.modify(filter, newValue);
        if (conf.hasFilterBinding(filter)) {
            throw new LocaleConfigurationException(this.inHelper.internationalize("henix.redminereq.filters.dialog.add.nonunique", LocaleContextHolder.getLocale()));
        }
        conf.addFilterBinding(filter);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void addFieldMapping(Long projectId, FieldMapping mapping) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        if (conf.hasFieldMapping(mapping)) {
            throw new LocaleConfigurationException(this.inHelper.getMessage("henix.redminereq.mappings.add.invalid", new Object[]{mapping.getSquashField()}, "field mapping invalid", LocaleContextHolder.getLocale()));
        }
        conf.addFieldMapping(mapping);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void removeFieldMappings(Long projectId, Collection<FieldMapping> mappings) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        for (FieldMapping map : mappings) {
            FieldMapping realItem = conf.getFieldMapping(map.getId());
            if (realItem == null || realItem.isLocked()) continue;
            conf.removeFieldMapping(realItem);
        }
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void resetFieldLinksByIds(Long projectId, Collection<String> ids) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        for (String id : ids) {
            FieldLink key = conf.getFieldLink(id);
            conf.resetFieldLink(key);
        }
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void removeFieldMappingsByIds(Long projectId, Collection<String> ids) {
        ArrayList<FieldMapping> keys = new ArrayList<FieldMapping>(ids.size());
        for (String id : ids) {
            FieldMapping key = FieldMapping.byId(id);
            keys.add(key);
        }
        this.removeFieldMappings(projectId, keys);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void updateFieldLinkSquashField(Long projectId, String linkId, String newValue) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        FieldLink link = conf.getFieldLink(linkId);
        if (link != null && newValue.equals(link.getSquashField())) {
            return;
        }
        if (link != null) {
            link.setSquashField(newValue);
        }
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void updateFieldMappingSquashField(Long projectId, String mappingId, String newValue) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        FieldMapping mapping = conf.getFieldMapping(mappingId);
        if (mapping != null) {
            if (mapping.getSquashField().equals(newValue)) {
                return;
            }
            if (conf.hasFieldMapping(newValue)) {
                throw new LocaleConfigurationException(this.inHelper.getMessage("henix.redminereq.mappings.add.invalid", new Object[]{newValue}, "field mapping invalid", LocaleContextHolder.getLocale()));
            }
            if (mapping.isLocked()) {
                throw new LocaleConfigurationException("atempted to modify a locked field mapping '" + mappingId + "' !");
            }
            mapping.setSquashField(newValue);
            this.dao.storeConfigurationForProject(projectId, conf);
        }
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void updateFieldMappingRedmineField(Long projectId, String mappingId, String newValue) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        FieldMapping mapping = conf.getFieldMapping(mappingId);
        if (mapping.isLocked()) {
            throw new LocaleConfigurationException("atempted to modify a locked field mapping '" + mappingId + "' !");
        }
        mapping.setRedmineField(newValue);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void updateValueMappings(Long projectId, String newValueMapping) {
        this.valueMappingsYamlDeserializer.deserialize(newValueMapping);
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setYamlFieldvalueMapping(newValueMapping);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @FunctionalInterface
    private static interface AttributeModifier {
        public void modify(FilterBinding var1, String var2);
    }
}

