/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.util.ArrayList;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.plugin.jirasync.domain.JiraSelectType;
import org.squashtest.tm.plugin.rest.admin.jackson.model.JiraRemoteSynchronisationModelDto;
import org.squashtest.tm.plugin.rest.admin.validators.RestJiraSyncApiValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;

@Component
public class RemoteSynchronisationValidator
extends RestJiraSyncApiValidator {
    private static final String ATTRIBUTE_CANNOT_BE_EMPTY = "This attribute cannot be empty.";
    private static final String POST_SYNCHRONISATION_VALIDATION = "post-synchronisation-validation";
    private static final String CANNOT_POST_GENERATED_ID = "This attribute is generated by database and should not be provided. If you want to update an existing synchronisation, please do a patch request to the synchronisation id.";

    public boolean supports(Class<?> clazz) {
        return JiraRemoteSynchronisationModelDto.class.equals(clazz);
    }

    public void validatePostRemoteSynchronisation(JiraRemoteSynchronisationModelDto synchronisationDto, long projectId) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)synchronisationDto, POST_SYNCHRONISATION_VALIDATION);
        this.checkEntityExist((Errors)validationBean, Project.class, projectId);
        this.checkSynchronisationId(synchronisationDto.getId(), (Errors)validationBean);
        this.checkServer(synchronisationDto.getServerId(), (Errors)validationBean);
        this.checkMandatoryAttributes((Errors)validationBean);
        this.checkSelectType(synchronisationDto.getSelectTypeConst(), (Errors)validationBean);
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)synchronisationDto, errors, (String)POST_SYNCHRONISATION_VALIDATION);
    }

    private void checkServer(Long serverId, Errors validationBean) {
        if (serverId == null) {
            validationBean.rejectValue("serverId", "required", ATTRIBUTE_CANNOT_BE_EMPTY);
        } else {
            this.checkEntityExist(validationBean, BugTracker.class, serverId);
        }
    }

    private void checkSynchronisationId(Long synchronisationId, Errors validationBean) {
        if (synchronisationId != null) {
            validationBean.rejectValue("id", "generated value", CANNOT_POST_GENERATED_ID);
        }
    }

    private void checkMandatoryAttributes(Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)ATTRIBUTE_CANNOT_BE_EMPTY);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"synchronisationPath", (String)"required", (String)ATTRIBUTE_CANNOT_BE_EMPTY);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"selectValue", (String)"required", (String)ATTRIBUTE_CANNOT_BE_EMPTY);
    }

    private void checkSelectType(String selectType, Errors validationBean) {
        if (selectType == null) {
            validationBean.rejectValue("selectTypeConst", "required", ATTRIBUTE_CANNOT_BE_EMPTY);
        } else {
            try {
                JiraSelectType.valueOf(selectType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                validationBean.rejectValue("selectTypeConst", "invalid attribute", "The attribute select_type is invalid.");
            }
        }
    }
}

