/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.nio;

import jirasync.org.apache.http.HttpRequest;
import jirasync.org.apache.http.HttpResponse;
import jirasync.org.apache.http.HttpResponseFactory;
import jirasync.org.apache.http.annotation.Contract;
import jirasync.org.apache.http.annotation.ThreadingBehavior;
import jirasync.org.apache.http.config.ConnectionConfig;
import jirasync.org.apache.http.entity.ContentLengthStrategy;
import jirasync.org.apache.http.impl.ConnSupport;
import jirasync.org.apache.http.impl.DefaultHttpResponseFactory;
import jirasync.org.apache.http.impl.nio.DefaultNHttpClientConnection;
import jirasync.org.apache.http.impl.nio.codecs.DefaultHttpResponseParserFactory;
import jirasync.org.apache.http.nio.NHttpConnectionFactory;
import jirasync.org.apache.http.nio.NHttpMessageParserFactory;
import jirasync.org.apache.http.nio.NHttpMessageWriterFactory;
import jirasync.org.apache.http.nio.reactor.IOSession;
import jirasync.org.apache.http.nio.util.ByteBufferAllocator;
import jirasync.org.apache.http.nio.util.HeapByteBufferAllocator;
import jirasync.org.apache.http.params.HttpParamConfig;
import jirasync.org.apache.http.params.HttpParams;
import jirasync.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultNHttpClientConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpClientConnection> {
    public static final DefaultNHttpClientConnectionFactory INSTANCE = new DefaultNHttpClientConnectionFactory();
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final NHttpMessageParserFactory<HttpResponse> responseParserFactory;
    private final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final ByteBufferAllocator allocator;
    private final ConnectionConfig cconfig;

    @Deprecated
    public DefaultNHttpClientConnectionFactory(HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        Args.notNull(responseFactory, "HTTP response factory");
        Args.notNull(allocator, "Byte buffer allocator");
        Args.notNull(params, "HTTP parameters");
        this.allocator = allocator;
        this.incomingContentStrategy = null;
        this.outgoingContentStrategy = null;
        this.responseParserFactory = new DefaultHttpResponseParserFactory(null, responseFactory);
        this.requestWriterFactory = null;
        this.cconfig = HttpParamConfig.getConnectionConfig(params);
    }

    @Deprecated
    public DefaultNHttpClientConnectionFactory(HttpParams params) {
        this(DefaultHttpResponseFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    public DefaultNHttpClientConnectionFactory(ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig cconfig) {
        this.incomingContentStrategy = incomingContentStrategy;
        this.outgoingContentStrategy = outgoingContentStrategy;
        this.responseParserFactory = responseParserFactory;
        this.requestWriterFactory = requestWriterFactory;
        this.allocator = allocator;
        this.cconfig = cconfig != null ? cconfig : ConnectionConfig.DEFAULT;
    }

    public DefaultNHttpClientConnectionFactory(NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig cconfig) {
        this(null, null, responseParserFactory, requestWriterFactory, allocator, cconfig);
    }

    public DefaultNHttpClientConnectionFactory(NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ConnectionConfig cconfig) {
        this(null, null, responseParserFactory, requestWriterFactory, null, cconfig);
    }

    public DefaultNHttpClientConnectionFactory(ConnectionConfig cconfig) {
        this(null, null, null, null, null, cconfig);
    }

    public DefaultNHttpClientConnectionFactory() {
        this(null, null, null, null, null, null);
    }

    @Deprecated
    protected DefaultNHttpClientConnection createConnection(IOSession session, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpClientConnection(session, responseFactory, allocator, params);
    }

    @Override
    public DefaultNHttpClientConnection createConnection(IOSession session) {
        return new DefaultNHttpClientConnection(session, this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), this.allocator, ConnSupport.createDecoder(this.cconfig), ConnSupport.createEncoder(this.cconfig), this.cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestWriterFactory, this.responseParserFactory);
    }
}

