/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.eclipse.lyo.oslc4j.provider.jena;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import plugin.rtc.javax.ws.rs.Consumes;
import plugin.rtc.javax.ws.rs.Produces;
import plugin.rtc.javax.ws.rs.WebApplicationException;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.ext.MessageBodyReader;
import plugin.rtc.javax.ws.rs.ext.MessageBodyWriter;
import plugin.rtc.javax.ws.rs.ext.Provider;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.FilteredResource;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.OslcMediaType;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ResponseInfo;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ResponseInfoArray;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ResponseInfoCollection;
import plugin.rtc.org.eclipse.lyo.oslc4j.provider.jena.AbstractOslcRdfXmlProvider;

@Provider
@Produces(value={"application/rdf+xml"})
@Consumes(value={"application/rdf+xml"})
public class OslcRdfXmlProvider
extends AbstractOslcRdfXmlProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    @Override
    public long getSize(Object object, Class<?> type, Type genericType, Annotation[] annotation, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Class actualType;
        if (FilteredResource.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length != 1) {
                return false;
            }
            if (actualTypeArguments[0] instanceof Class) {
                actualType = (Class)actualTypeArguments[0];
            } else if (actualTypeArguments[0] instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)actualTypeArguments[0];
                if ((actualTypeArguments = parameterizedType.getActualTypeArguments()).length != 1 || !(actualTypeArguments[0] instanceof Class)) {
                    return false;
                }
                actualType = (Class)actualTypeArguments[0];
            } else if (actualTypeArguments[0] instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)actualTypeArguments[0];
                Type componentType = genericArrayType.getGenericComponentType();
                if (!(componentType instanceof Class)) {
                    return false;
                }
                actualType = (Class)componentType;
            } else {
                return false;
            }
            Type rawType = parameterizedType.getRawType();
            if (URI.class.equals((Object)actualType) && (ResponseInfoCollection.class.equals((Object)rawType) || ResponseInfoArray.class.equals((Object)rawType))) {
                return true;
            }
        } else {
            actualType = type;
        }
        return OslcRdfXmlProvider.isWriteable(actualType, annotations, mediaType, OslcMediaType.APPLICATION_RDF_XML_TYPE, OslcMediaType.APPLICATION_XML_TYPE, OslcMediaType.TEXT_XML_TYPE, OslcMediaType.TEXT_TURTLE_TYPE);
    }

    @Override
    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> map, OutputStream outputStream) throws IOException, WebApplicationException {
        Object[] objects;
        Map<String, Object> properties = null;
        String descriptionURI = null;
        String responseInfoURI = null;
        ResponseInfo responseInfo = null;
        if (object instanceof FilteredResource) {
            FilteredResource filteredResource = (FilteredResource)object;
            properties = filteredResource.properties();
            if (filteredResource instanceof ResponseInfo) {
                String queryString;
                URI containerAboutURI;
                String requestURI;
                responseInfo = (ResponseInfo)filteredResource;
                responseInfoURI = requestURI = OSLC4JUtils.resolveURI(this.httpServletRequest, true);
                FilteredResource container = responseInfo.getContainer();
                if (container != null && (containerAboutURI = container.getAbout()) != null) {
                    descriptionURI = containerAboutURI.toString();
                }
                if (null == descriptionURI) {
                    descriptionURI = requestURI;
                }
                if ((queryString = this.httpServletRequest.getQueryString()) != null && OslcRdfXmlProvider.isOslcQuery(queryString)) {
                    responseInfoURI = responseInfoURI + "?" + queryString;
                }
                if (filteredResource instanceof ResponseInfoArray) {
                    objects = ((ResponseInfoArray)filteredResource).array();
                } else {
                    Collection<Object> collection = ((ResponseInfoCollection)filteredResource).collection();
                    objects = collection.toArray(new Object[collection.size()]);
                }
            } else {
                Object nestedObject = filteredResource.resource();
                objects = nestedObject instanceof Object[] ? (Object[])nestedObject : (nestedObject instanceof Collection ? ((Collection)nestedObject).toArray() : new Object[]{object});
            }
        } else {
            objects = new Object[]{object};
        }
        this.writeTo(objects, mediaType, map, outputStream, properties, descriptionURI, responseInfoURI, responseInfo);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return OslcRdfXmlProvider.isReadable(type, mediaType, OslcMediaType.APPLICATION_RDF_XML_TYPE, OslcMediaType.APPLICATION_XML_TYPE, OslcMediaType.TEXT_XML_TYPE, OslcMediaType.TEXT_TURTLE_TYPE);
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> map, InputStream inputStream) throws IOException, WebApplicationException {
        Object[] objects = this.readFrom(type, mediaType, map, inputStream);
        if (objects != null && objects.length > 0) {
            if (OSLC4JUtils.useBeanClassForParsing() && objects.length > 1) {
                throw new IOException("Object length should not be greater than 1.");
            }
            return objects[0];
        }
        return null;
    }
}

