/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.eclipse.lyo.oslc4j.core.model;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.javax.ws.rs.GET;
import plugin.rtc.javax.ws.rs.POST;
import plugin.rtc.javax.ws.rs.Path;
import plugin.rtc.javax.ws.rs.core.UriBuilder;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcCreationFactory;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcDialog;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcDialogs;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcQueryCapability;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcService;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.exception.OslcCoreMissingAnnotationException;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.CreationFactory;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Dialog;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Publisher;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.QueryCapability;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Service;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ServiceProvider;

public final class ServiceProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(ServiceProviderFactory.class);

    private ServiceProviderFactory() {
    }

    public static ServiceProvider createServiceProvider(String baseURI, String genericBaseURI, String title, String description, Publisher publisher, Class<?>[] resourceClasses) throws OslcCoreApplicationException, URISyntaxException {
        return ServiceProviderFactory.initServiceProvider(new ServiceProvider(), baseURI, genericBaseURI, title, description, publisher, resourceClasses, null);
    }

    public static ServiceProvider createServiceProvider(String baseURI, String genericBaseURI, String title, String description, Publisher publisher, Class<?>[] resourceClasses, Map<String, Object> pathParameterValues) throws OslcCoreApplicationException, URISyntaxException {
        return ServiceProviderFactory.initServiceProvider(new ServiceProvider(), baseURI, genericBaseURI, title, description, publisher, resourceClasses, pathParameterValues);
    }

    public static ServiceProvider initServiceProvider(ServiceProvider serviceProvider, String baseURI, String genericBaseURI, String title, String description, Publisher publisher, Class<?>[] resourceClasses, Map<String, Object> pathParameterValues) throws OslcCoreApplicationException, URISyntaxException {
        serviceProvider.setTitle(title);
        serviceProvider.setDescription(description);
        serviceProvider.setPublisher(publisher);
        HashMap<String, Service> serviceMap = new HashMap<String, Service>();
        for (Class<?> resourceClass : resourceClasses) {
            OslcService serviceAnnotation = resourceClass.getAnnotation(OslcService.class);
            if (serviceAnnotation == null) {
                throw new OslcCoreMissingAnnotationException(resourceClass, OslcService.class);
            }
            String domain = serviceAnnotation.value();
            Service service = (Service)serviceMap.get(domain);
            if (service == null) {
                service = new Service(new URI(domain));
                serviceMap.put(domain, service);
            }
            ServiceProviderFactory.handleResourceClass(baseURI, genericBaseURI, resourceClass, service, pathParameterValues);
        }
        for (Service service : serviceMap.values()) {
            serviceProvider.addService(service);
        }
        return serviceProvider;
    }

    private static void handleResourceClass(String baseURI, String genericBaseURI, Class<?> resourceClass, Service service, Map<String, Object> pathParameterValues) throws URISyntaxException {
        for (Method method : resourceClass.getMethods()) {
            OslcDialogs dialogsAnnotation;
            GET getAnnotation = method.getAnnotation(GET.class);
            if (getAnnotation != null) {
                OslcDialogs dialogsAnnotation2;
                OslcQueryCapability queryCapabilityAnnotation = method.getAnnotation(OslcQueryCapability.class);
                String[] resourceShapes = null;
                if (queryCapabilityAnnotation != null) {
                    service.addQueryCapability(ServiceProviderFactory.createQueryCapability(baseURI, method, pathParameterValues));
                    String resourceShape = queryCapabilityAnnotation.resourceShape();
                    if (resourceShape != null && resourceShape.length() > 0) {
                        resourceShapes = new String[]{resourceShape};
                    }
                }
                if ((dialogsAnnotation2 = method.getAnnotation(OslcDialogs.class)) != null) {
                    OslcDialog[] dialogs;
                    for (OslcDialog dialog : dialogs = dialogsAnnotation2.value()) {
                        if (dialog == null) continue;
                        service.addSelectionDialog(ServiceProviderFactory.createSelectionDialog(baseURI, genericBaseURI, method, dialog, resourceShapes, pathParameterValues));
                    }
                    continue;
                }
                OslcDialog dialogAnnotation = method.getAnnotation(OslcDialog.class);
                if (dialogAnnotation == null) continue;
                service.addSelectionDialog(ServiceProviderFactory.createSelectionDialog(baseURI, genericBaseURI, method, dialogAnnotation, resourceShapes, pathParameterValues));
                continue;
            }
            POST postAnnotation = method.getAnnotation(POST.class);
            if (postAnnotation == null) continue;
            OslcCreationFactory creationFactoryAnnotation = method.getAnnotation(OslcCreationFactory.class);
            String[] resourceShapes = null;
            if (creationFactoryAnnotation != null) {
                service.addCreationFactory(ServiceProviderFactory.createCreationFactory(baseURI, pathParameterValues, method));
                resourceShapes = creationFactoryAnnotation.resourceShapes();
            }
            if ((dialogsAnnotation = method.getAnnotation(OslcDialogs.class)) != null) {
                OslcDialog[] dialogs;
                for (OslcDialog dialog : dialogs = dialogsAnnotation.value()) {
                    if (dialog == null) continue;
                    service.addCreationDialog(ServiceProviderFactory.createCreationDialog(baseURI, genericBaseURI, method, dialog, resourceShapes, pathParameterValues));
                }
                continue;
            }
            OslcDialog dialogAnnotation = method.getAnnotation(OslcDialog.class);
            if (dialogAnnotation == null) continue;
            service.addCreationDialog(ServiceProviderFactory.createCreationDialog(baseURI, genericBaseURI, method, dialogAnnotation, resourceShapes, pathParameterValues));
        }
    }

    protected static CreationFactory createCreationFactory(String baseURI, Map<String, Object> pathParameterValues, Method method) throws URISyntaxException {
        Path classPathAnnotation = method.getDeclaringClass().getAnnotation(Path.class);
        OslcCreationFactory creationFactoryAnnotation = method.getAnnotation(OslcCreationFactory.class);
        Path methodPathAnnotation = method.getAnnotation(Path.class);
        CreationFactory creationFactory = ServiceProviderFactory.createCreationFactory(baseURI, pathParameterValues, classPathAnnotation, creationFactoryAnnotation, methodPathAnnotation);
        return creationFactory;
    }

    protected static CreationFactory createCreationFactory(String baseURI, Map<String, Object> pathParameterValues, Path classPathAnnotation, OslcCreationFactory creationFactoryAnnotation, Path methodPathAnnotation) throws URISyntaxException {
        String title = creationFactoryAnnotation.title();
        String label = creationFactoryAnnotation.label();
        String[] resourceShapes = creationFactoryAnnotation.resourceShapes();
        String[] resourceTypes = creationFactoryAnnotation.resourceTypes();
        String[] usages = creationFactoryAnnotation.usages();
        String basePath = baseURI + "/";
        String creation = ServiceProviderFactory.resolvePathParameters(basePath, ServiceProviderFactory.pathAnnotationStringValue(classPathAnnotation), ServiceProviderFactory.pathAnnotationStringValue(methodPathAnnotation), pathParameterValues);
        CreationFactory creationFactory = new CreationFactory(title, new URI(creation).normalize());
        if (label != null && label.length() > 0) {
            creationFactory.setLabel(label);
        }
        for (String resourceShape : resourceShapes) {
            creationFactory.addResourceShape(new URI(basePath + resourceShape).normalize());
        }
        for (String resourceType : resourceTypes) {
            creationFactory.addResourceType(new URI(resourceType));
        }
        for (String usage : usages) {
            creationFactory.addUsage(new URI(usage));
        }
        return creationFactory;
    }

    private static String pathAnnotationStringValue(Path pathAnnotation) {
        return pathAnnotation == null ? null : pathAnnotation.value();
    }

    private static QueryCapability createQueryCapability(String baseURI, Method method, Map<String, Object> pathParameterValues) throws URISyntaxException {
        OslcQueryCapability queryCapabilityAnnotation = method.getAnnotation(OslcQueryCapability.class);
        String title = queryCapabilityAnnotation.title();
        String label = queryCapabilityAnnotation.label();
        String resourceShape = queryCapabilityAnnotation.resourceShape();
        String[] resourceTypes = queryCapabilityAnnotation.resourceTypes();
        String[] usages = queryCapabilityAnnotation.usages();
        String basePath = baseURI + "/";
        Path classPathAnnotation = method.getDeclaringClass().getAnnotation(Path.class);
        Path methodPathAnnotation = method.getAnnotation(Path.class);
        String query2 = ServiceProviderFactory.resolvePathParameters(basePath, ServiceProviderFactory.pathAnnotationStringValue(classPathAnnotation), ServiceProviderFactory.pathAnnotationStringValue(methodPathAnnotation), pathParameterValues);
        QueryCapability queryCapability = new QueryCapability(title, new URI(query2).normalize());
        if (label != null && label.length() > 0) {
            queryCapability.setLabel(label);
        }
        if (resourceShape != null && resourceShape.length() > 0) {
            queryCapability.setResourceShape(new URI(basePath + resourceShape).normalize());
        }
        for (String resourceType : resourceTypes) {
            queryCapability.addResourceType(new URI(resourceType));
        }
        for (String usage : usages) {
            queryCapability.addUsage(new URI(usage));
        }
        return queryCapability;
    }

    private static Dialog createCreationDialog(String baseURI, String genericBaseURI, Method method, OslcDialog dialogAnnotation, String[] resourceShapes, Map<String, Object> pathParameterValues) throws URISyntaxException {
        return ServiceProviderFactory.createDialog(baseURI, genericBaseURI, "Creation", "creation", method, dialogAnnotation, resourceShapes, pathParameterValues);
    }

    private static Dialog createSelectionDialog(String baseURI, String genericBaseURI, Method method, OslcDialog dialogAnnotation, String[] resourceShapes, Map<String, Object> pathParameterValues) throws URISyntaxException {
        return ServiceProviderFactory.createDialog(baseURI, genericBaseURI, "Selection", "queryBase", method, dialogAnnotation, resourceShapes, pathParameterValues);
    }

    private static Dialog createDialog(String baseURI, String genericBaseURI, String dialogType, String parameterName, Method method, OslcDialog dialogAnnotation, String[] resourceShapes, Map<String, Object> pathParameterValues) throws URISyntaxException {
        String title = dialogAnnotation.title();
        String label = dialogAnnotation.label();
        String dialogURI = dialogAnnotation.uri();
        String hintWidth = dialogAnnotation.hintWidth();
        String hintHeight = dialogAnnotation.hintHeight();
        String[] resourceTypes = dialogAnnotation.resourceTypes();
        String[] usages = dialogAnnotation.usages();
        String uri = "";
        Path classPathAnnotation = method.getDeclaringClass().getAnnotation(Path.class);
        if (dialogURI.length() > 0) {
            uri = ServiceProviderFactory.resolvePathParameters(baseURI, null, dialogURI, pathParameterValues);
        } else {
            uri = genericBaseURI + "/generic/generic" + dialogType + ".html";
            Path methodPathAnnotation = method.getAnnotation(Path.class);
            String parameter = ServiceProviderFactory.resolvePathParameters(baseURI, ServiceProviderFactory.pathAnnotationStringValue(classPathAnnotation), ServiceProviderFactory.pathAnnotationStringValue(methodPathAnnotation), pathParameterValues);
            try {
                String encodedParameter = URLEncoder.encode(parameter, "UTF-8");
                uri = uri + "?" + parameterName + "=" + encodedParameter;
            }
            catch (UnsupportedEncodingException exception) {
                log.warn("Error encoding URI [{}]", (Object)parameter, (Object)exception);
            }
            StringBuilder resourceShapeParameters = new StringBuilder();
            if (resourceShapes != null) {
                for (String resourceShape : resourceShapes) {
                    String resourceShapeURI = baseURI + '/' + resourceShape;
                    try {
                        String encodedResourceShape = URLEncoder.encode(resourceShapeURI, "UTF-8");
                        resourceShapeParameters.append("&resourceShape=").append(encodedResourceShape);
                    }
                    catch (UnsupportedEncodingException exception) {
                        log.warn("Error encoding URI [{}]", (Object)resourceShapeURI, (Object)exception);
                    }
                }
            }
            uri = uri + resourceShapeParameters.toString();
        }
        Dialog dialog = new Dialog(title, new URI(uri).normalize());
        if (label != null && label.length() > 0) {
            dialog.setLabel(label);
        }
        if (hintWidth != null && hintWidth.length() > 0) {
            dialog.setHintWidth(hintWidth);
        }
        if (hintHeight != null && hintHeight.length() > 0) {
            dialog.setHintHeight(hintHeight);
        }
        for (String resourceType : resourceTypes) {
            dialog.addResourceType(new URI(resourceType));
        }
        for (String usage : usages) {
            dialog.addUsage(new URI(usage));
        }
        return dialog;
    }

    private static String resolvePathParameters(String basePath, String classPathAnnotation, String methodPathAnnotation, Map<String, Object> pathParameterValues) {
        UriBuilder builder = UriBuilder.fromUri(basePath);
        if (classPathAnnotation != null && !classPathAnnotation.equals("")) {
            builder.path(classPathAnnotation);
        }
        if (methodPathAnnotation != null && !methodPathAnnotation.equals("")) {
            builder.path(methodPathAnnotation);
        }
        String returnUri = null;
        URI resolvedUri = builder.buildFromMap(pathParameterValues);
        if (resolvedUri != null) {
            returnUri = resolvedUri.toString();
        }
        return returnUri;
    }
}

