/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.json4j.utils.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSONObject {
    private static String className = "org.apache.commons.json.uils.xml.internal.JSONObject";
    private static Logger logger = Logger.getLogger(className, null);
    private static final String indent = "   ";
    private String objectName = null;
    private Properties attrs = null;
    private Hashtable jsonObjects = null;
    private String tagText = null;

    public JSONObject(String objectName, Properties attrs) {
        this.objectName = objectName;
        this.attrs = attrs;
        this.jsonObjects = new Hashtable();
    }

    public void addJSONObject(JSONObject obj) {
        Vector<JSONObject> vect;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "addJSONObject(JSONObject)");
        }
        if ((vect = (Vector<JSONObject>)this.jsonObjects.get(obj.objectName)) != null) {
            vect.add(obj);
        } else {
            vect = new Vector<JSONObject>();
            vect.add(obj);
            this.jsonObjects.put(obj.objectName, vect);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "addJSONObject(JSONObject)");
        }
    }

    public void setTagText(String str) {
        this.tagText = str;
    }

    public String getTagText() {
        return this.tagText;
    }

    public void writeObject(Writer writer, int indentDepth, boolean contentOnly) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeObject(Writer, int, boolean)");
        }
        this.writeObject(writer, indentDepth, contentOnly, false);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeObject(Writer, int, boolean)");
        }
    }

    public void writeObject(Writer writer, int indentDepth, boolean contentOnly, boolean compact) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeObject(Writer, int, boolean, boolean)");
        }
        if (writer != null) {
            try {
                if (this.isEmptyObject()) {
                    this.writeEmptyObject(writer, indentDepth, contentOnly, compact);
                }
                if (this.isTextOnlyObject()) {
                    this.writeTextOnlyObject(writer, indentDepth, contentOnly, compact);
                }
                this.writeComplexObject(writer, indentDepth, contentOnly, compact);
            }
            catch (Exception ex) {
                IOException iox = new IOException("Error occurred on serialization of JSON text.");
                iox.initCause(ex);
                throw iox;
            }
        } else {
            throw new IOException("The writer cannot be null.");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeObject(Writer, int, boolean, boolean)");
        }
    }

    private void writeAttribute(Writer writer, String name, String value, int depth, boolean compact) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeAttribute(Writer, String, String, int)");
        }
        if (!compact) {
            this.writeIndention(writer, depth);
        }
        try {
            if (!compact) {
                writer.write("\"" + name + "\"" + " : " + "\"" + this.escapeStringSpecialCharacters(value) + "\"");
            } else {
                writer.write("\"" + name + "\"" + ":" + "\"" + this.escapeStringSpecialCharacters(value) + "\"");
            }
        }
        catch (Exception ex) {
            IOException iox = new IOException("Error occurred on serialization of JSON text.");
            iox.initCause(ex);
            throw iox;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeAttribute(Writer, String, String, int)");
        }
    }

    private void writeIndention(Writer writer, int indentDepth) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeIndention(Writer, int)");
        }
        try {
            for (int i = 0; i < indentDepth; ++i) {
                writer.write(indent);
            }
        }
        catch (Exception ex) {
            IOException iox = new IOException("Error occurred on serialization of JSON text.");
            iox.initCause(ex);
            throw iox;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeIndention(Writer, int)");
        }
    }

    private void writeAttributes(Writer writer, Properties attrs, int depth, boolean compact) throws IOException {
        Enumeration<?> props;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeAttributes(Writer, Properties, int, boolean)");
        }
        if (attrs != null && (props = attrs.propertyNames()) != null && props.hasMoreElements()) {
            while (props.hasMoreElements()) {
                String prop = (String)props.nextElement();
                this.writeAttribute(writer, this.escapeAttributeNameSpecialCharacters(prop), (String)attrs.get(prop), depth + 1, compact);
                if (!props.hasMoreElements()) continue;
                try {
                    if (!compact) {
                        writer.write(",\n");
                        continue;
                    }
                    writer.write(",");
                }
                catch (Exception ex) {
                    IOException iox = new IOException("Error occurred on serialization of JSON text.");
                    iox.initCause(ex);
                    throw iox;
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeAttributes(Writer, Properties, int, boolean)");
        }
    }

    private String escapeAttributeNameSpecialCharacters(String str) {
        if (str != null) {
            StringBuffer strBuf = new StringBuffer("");
            block3: for (int i = 0; i < str.length(); ++i) {
                char strChar = str.charAt(i);
                switch (strChar) {
                    case ':': {
                        strBuf.append("_ns-sep_");
                        continue block3;
                    }
                    default: {
                        strBuf.append(strChar);
                    }
                }
            }
            str = strBuf.toString();
        }
        return str;
    }

    private String escapeStringSpecialCharacters(String str) {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "escapeStringSpecialCharacters(String)");
        }
        if (str != null) {
            StringBuffer strBuf = new StringBuffer("");
            block9: for (int i = 0; i < str.length(); ++i) {
                char strChar = str.charAt(i);
                switch (strChar) {
                    case '\"': {
                        strBuf.append("\\\"");
                        continue block9;
                    }
                    case '\t': {
                        strBuf.append("\\t");
                        continue block9;
                    }
                    case '\b': {
                        strBuf.append("\\b");
                        continue block9;
                    }
                    case '\\': {
                        strBuf.append("\\\\");
                        continue block9;
                    }
                    case '\f': {
                        strBuf.append("\\f");
                        continue block9;
                    }
                    case '\r': {
                        strBuf.append("\\r");
                        continue block9;
                    }
                    case '/': {
                        strBuf.append("\\/");
                        continue block9;
                    }
                    default: {
                        if (strChar >= ' ' && strChar <= '~') {
                            strBuf.append(strChar);
                            continue block9;
                        }
                        strBuf.append("\\u");
                        StringBuffer sb = new StringBuffer(Integer.toHexString(strChar));
                        while (sb.length() < 4) {
                            sb.insert(0, '0');
                        }
                        strBuf.append(sb.toString());
                    }
                }
            }
            str = strBuf.toString();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "escapeStringSpecialCharacters(String)");
        }
        return str;
    }

    private void writeChildren(Writer writer, int depth, boolean compact) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeChildren(Writer, int, boolean)");
        }
        if (!this.jsonObjects.isEmpty()) {
            Enumeration keys = this.jsonObjects.keys();
            while (keys.hasMoreElements()) {
                String objName = (String)keys.nextElement();
                Vector vect = (Vector)this.jsonObjects.get(objName);
                if (vect == null || vect.isEmpty()) continue;
                if (vect.size() == 1) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, className, "writeChildren(Writer, int, boolean)", "Writing child object: [" + objName + "]");
                    }
                    JSONObject obj = (JSONObject)vect.elementAt(0);
                    obj.writeObject(writer, depth + 1, false, compact);
                    if (keys.hasMoreElements()) {
                        try {
                            if (!compact) {
                                if (!obj.isTextOnlyObject() && !obj.isEmptyObject()) {
                                    this.writeIndention(writer, depth + 1);
                                }
                                writer.write(",\n");
                                continue;
                            }
                            writer.write(",");
                            continue;
                        }
                        catch (Exception ex) {
                            IOException iox = new IOException("Error occurred on serialization of JSON text.");
                            iox.initCause(ex);
                            throw iox;
                        }
                    }
                    if (!obj.isTextOnlyObject() || compact) continue;
                    writer.write("\n");
                    continue;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, className, "writeChildren(Writer, int, boolean)", "Writing array of JSON objects with attribute name: [" + objName + "]");
                }
                try {
                    if (!compact) {
                        this.writeIndention(writer, depth + 1);
                        writer.write("\"" + objName + "\"");
                        writer.write(" : [\n");
                    } else {
                        writer.write("\"" + objName + "\"");
                        writer.write(":[");
                    }
                    for (int i = 0; i < vect.size(); ++i) {
                        JSONObject obj = (JSONObject)vect.elementAt(i);
                        obj.writeObject(writer, depth + 2, true, compact);
                        if (i == vect.size() - 1) continue;
                        if (!compact) {
                            if (!obj.isTextOnlyObject() && !obj.isEmptyObject()) {
                                this.writeIndention(writer, depth + 2);
                            }
                            writer.write(",\n");
                            continue;
                        }
                        writer.write(",");
                    }
                    if (!compact) {
                        writer.write("\n");
                        this.writeIndention(writer, depth + 1);
                    }
                    writer.write("]");
                    if (keys.hasMoreElements()) {
                        writer.write(",");
                    }
                    if (compact) continue;
                    writer.write("\n");
                }
                catch (Exception ex) {
                    IOException iox = new IOException("Error occurred on serialization of JSON text.");
                    iox.initCause(ex);
                    throw iox;
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeChildren(Writer, int, boolean)");
        }
    }

    private void writeEmptyObject(Writer writer, int indentDepth, boolean contentOnly, boolean compact) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeEmptyObject(Writer, int, boolean, boolean)");
        }
        if (!contentOnly) {
            if (!compact) {
                this.writeIndention(writer, indentDepth);
                writer.write("\"" + this.objectName + "\"");
                writer.write(" : true");
            } else {
                writer.write("\"" + this.objectName + "\"");
                writer.write(":true");
            }
        } else if (!compact) {
            this.writeIndention(writer, indentDepth);
            writer.write("true");
        } else {
            writer.write("true");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeEmptyObject(Writer, int, boolean, boolean)");
        }
    }

    private void writeTextOnlyObject(Writer writer, int indentDepth, boolean contentOnly, boolean compact) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeTextOnlyObject(Writer, int, boolean, boolean)");
        }
        if (!contentOnly) {
            this.writeAttribute(writer, this.objectName, this.tagText.trim(), indentDepth, compact);
        } else if (!compact) {
            this.writeIndention(writer, indentDepth);
            writer.write("\"" + this.escapeStringSpecialCharacters(this.tagText.trim()) + "\"");
        } else {
            writer.write("\"" + this.escapeStringSpecialCharacters(this.tagText.trim()) + "\"");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeTextOnlyObject(Writer, int, boolean, boolean)");
        }
    }

    private void writeComplexObject(Writer writer, int indentDepth, boolean contentOnly, boolean compact) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeComplexObject(Writer, int, boolean, boolean)");
        }
        boolean wroteTagText = false;
        if (!contentOnly) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, className, "writeComplexObject(Writer, int, boolean, boolean)", "Writing object: [" + this.objectName + "]");
            }
            if (!compact) {
                this.writeIndention(writer, indentDepth);
            }
            writer.write("\"" + this.objectName + "\"");
            if (!compact) {
                writer.write(" : {\n");
            } else {
                writer.write(":{");
            }
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, className, "writeObject(Writer, int, boolean, boolean)", "Writing object contents as an anonymous object (usually an array entry)");
            }
            if (!compact) {
                this.writeIndention(writer, indentDepth);
                writer.write("{\n");
            } else {
                writer.write("{");
            }
        }
        if (this.tagText != null && !this.tagText.equals("") && !this.tagText.trim().equals("")) {
            this.writeAttribute(writer, "content", this.tagText.trim(), indentDepth + 1, compact);
            wroteTagText = true;
        }
        if (this.attrs != null && !this.attrs.isEmpty() && wroteTagText) {
            if (!compact) {
                writer.write(",\n");
            } else {
                writer.write(",");
            }
        }
        this.writeAttributes(writer, this.attrs, indentDepth, compact);
        if (!this.jsonObjects.isEmpty()) {
            if (this.attrs != null && (!this.attrs.isEmpty() || wroteTagText)) {
                if (!compact) {
                    writer.write(",\n");
                } else {
                    writer.write(",");
                }
            } else if (!compact) {
                writer.write("\n");
            }
            this.writeChildren(writer, indentDepth, compact);
        } else if (!compact) {
            writer.write("\n");
        }
        if (!compact) {
            this.writeIndention(writer, indentDepth);
            writer.write("}\n");
        } else {
            writer.write("}");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeComplexObject(Writer, int, boolean, boolean)");
        }
    }

    private boolean isEmptyObject() {
        boolean retVal = false;
        if ((this.attrs == null || this.attrs != null && this.attrs.isEmpty()) && this.jsonObjects.isEmpty() && (this.tagText == null || this.tagText != null && this.tagText.trim().equals(""))) {
            retVal = true;
        }
        return retVal;
    }

    private boolean isTextOnlyObject() {
        boolean retVal = false;
        if ((this.attrs == null || this.attrs != null && this.attrs.isEmpty()) && this.jsonObjects.isEmpty() && this.tagText != null && !this.tagText.trim().equals("")) {
            retVal = true;
        }
        return retVal;
    }
}

