/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.model.rss;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import plugin.rtc.org.apache.wink.common.model.rss.RssCategory;
import plugin.rtc.org.apache.wink.common.model.rss.RssChannel;
import plugin.rtc.org.apache.wink.common.model.rss.RssEnclosure;
import plugin.rtc.org.apache.wink.common.model.rss.RssGuid;
import plugin.rtc.org.apache.wink.common.model.rss.RssSource;
import plugin.rtc.org.apache.wink.common.model.synd.SyndCategory;
import plugin.rtc.org.apache.wink.common.model.synd.SyndEntry;
import plugin.rtc.org.apache.wink.common.model.synd.SyndLink;
import plugin.rtc.org.apache.wink.common.model.synd.SyndPerson;
import plugin.rtc.org.apache.wink.common.model.synd.SyndText;
import plugin.rtc.org.apache.wink.common.model.synd.SyndTextType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="rssItem", propOrder={})
public class RssItem {
    protected String title;
    @XmlSchemaType(name="anyURI")
    protected String link;
    protected String description;
    protected String author;
    protected List<RssCategory> category;
    @XmlSchemaType(name="anyURI")
    protected String comments;
    protected RssEnclosure enclosure;
    protected RssGuid guid;
    @XmlElement(required=true)
    protected String pubDate;
    protected RssSource source;
    @XmlAnyElement(lax=true)
    protected List<Object> any;

    public RssItem() {
    }

    public RssItem(SyndEntry syndEntry) {
        SyndPerson syndAuthor;
        SyndLink link;
        if (syndEntry.getTitle() != null && syndEntry.getTitle().getValue() != null) {
            this.setTitle(syndEntry.getTitle().getValue());
        }
        if ((link = syndEntry.getLink("alternate")) != null && link.getHref() != null) {
            this.setLink(link.getHref());
        }
        if (syndEntry.getSummary() != null && syndEntry.getSummary().getValue() != null) {
            this.setDescription(syndEntry.getSummary().getValue());
        }
        if (syndEntry.getAuthors().size() > 0 && (syndAuthor = syndEntry.getAuthors().get(0)).getEmail() != null) {
            this.setAuthor(syndAuthor.getEmail());
        }
        this.getCategories().clear();
        for (SyndCategory syndCategory : syndEntry.getCategories()) {
            this.getCategories().add(new RssCategory(syndCategory));
        }
        link = syndEntry.getLink("enclosure");
        if (link != null) {
            this.setEnclosure(new RssEnclosure(link));
        }
        if (syndEntry.getId() != null) {
            RssGuid rssGuid = new RssGuid();
            rssGuid.setContent(syndEntry.getId());
            this.setGuid(rssGuid);
        }
        if (syndEntry.getPublished() != null) {
            this.setPubDate(RssChannel.convertJavaDateToRssDate(syndEntry.getPublished()));
        }
    }

    public SyndEntry toSynd(SyndEntry syndEntry) {
        if (syndEntry == null) {
            return syndEntry;
        }
        if (this.getTitle() != null) {
            syndEntry.setTitle(new SyndText(this.getTitle(), SyndTextType.text));
        }
        if (this.getLink() != null) {
            SyndLink syndLink = new SyndLink();
            syndLink.setHref(this.getLink());
            syndLink.setRel("alternate");
            syndEntry.getLinks().add(syndLink);
        }
        if (this.getDescription() != null) {
            syndEntry.setSummary(new SyndText(this.getDescription()));
        }
        if (this.getAuthor() != null) {
            SyndPerson syndAuthor = new SyndPerson();
            String authorEmail = this.getAuthor();
            syndAuthor.setEmail(authorEmail);
            syndAuthor.setName(authorEmail.substring(0, authorEmail.indexOf("@")));
            syndEntry.getAuthors().add(syndAuthor);
        }
        syndEntry.getCategories().clear();
        for (RssCategory rssCategory : this.getCategories()) {
            SyndCategory syndCategory = new SyndCategory();
            syndCategory = rssCategory.toSynd(syndCategory);
            syndEntry.getCategories().add(syndCategory);
        }
        if (this.getEnclosure() != null) {
            SyndLink syndEnclosureLink = new SyndLink();
            syndEnclosureLink = this.getEnclosure().toSynd(syndEnclosureLink);
            syndEntry.getLinks().add(syndEnclosureLink);
        }
        if (this.getGuid() != null) {
            syndEntry.setId(this.getGuid().getContent());
        }
        if (this.getPubDate() != null) {
            syndEntry.setPublished(RssChannel.convertRssDateToJavaDate(this.getPubDate()));
        }
        return syndEntry;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String value) {
        this.link = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String value) {
        this.author = value;
    }

    public List<RssCategory> getCategories() {
        if (this.category == null) {
            this.category = new ArrayList<RssCategory>();
        }
        return this.category;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String value) {
        this.comments = value;
    }

    public RssEnclosure getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(RssEnclosure value) {
        this.enclosure = value;
    }

    public RssGuid getGuid() {
        return this.guid;
    }

    public void setGuid(RssGuid value) {
        this.guid = value;
    }

    public String getPubDate() {
        return this.pubDate;
    }

    public void setPubDate(String value) {
        this.pubDate = value;
    }

    public RssSource getSource() {
        return this.source;
    }

    public void setSource(RssSource value) {
        this.source = value;
    }

    public List<Object> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Object>();
        }
        return this.any;
    }
}

