/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.model.rss;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;
import plugin.rtc.org.apache.wink.common.model.rss.RssCategory;
import plugin.rtc.org.apache.wink.common.model.rss.RssCloud;
import plugin.rtc.org.apache.wink.common.model.rss.RssImage;
import plugin.rtc.org.apache.wink.common.model.rss.RssItem;
import plugin.rtc.org.apache.wink.common.model.rss.RssSkipDays;
import plugin.rtc.org.apache.wink.common.model.rss.RssSkipHours;
import plugin.rtc.org.apache.wink.common.model.rss.RssTextInput;
import plugin.rtc.org.apache.wink.common.model.synd.SyndCategory;
import plugin.rtc.org.apache.wink.common.model.synd.SyndEntry;
import plugin.rtc.org.apache.wink.common.model.synd.SyndFeed;
import plugin.rtc.org.apache.wink.common.model.synd.SyndGenerator;
import plugin.rtc.org.apache.wink.common.model.synd.SyndLink;
import plugin.rtc.org.apache.wink.common.model.synd.SyndPerson;
import plugin.rtc.org.apache.wink.common.model.synd.SyndText;
import plugin.rtc.org.apache.wink.common.model.synd.SyndTextType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="rssChannel", propOrder={})
public class RssChannel {
    @XmlElement(required=true)
    protected String title;
    @XmlElement(required=true)
    @XmlSchemaType(name="anyURI")
    protected String link;
    @XmlElement(required=true)
    protected String description;
    protected String language;
    protected String copyright;
    protected String managingEditor;
    protected String webMaster;
    protected String pubDate;
    protected String lastBuildDate;
    protected List<RssCategory> category;
    protected String generator;
    @XmlSchemaType(name="anyURI")
    protected String docs;
    protected RssCloud cloud;
    protected Integer ttl;
    protected RssImage image;
    protected String rating;
    protected RssTextInput textInput;
    protected RssSkipHours skipHours;
    protected RssSkipDays skipDays;
    @XmlAnyElement(lax=true)
    protected List<Object> any;
    protected List<RssItem> item;
    private static String RSS_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss z";
    private static final Logger logger = LoggerFactory.getLogger(RssChannel.class);

    public RssChannel() {
    }

    public RssChannel(SyndFeed syndFeed) {
        SyndPerson author;
        SyndLink link;
        if (syndFeed == null) {
            return;
        }
        if (syndFeed.getTitle() != null && syndFeed.getTitle().getValue() != null) {
            this.setTitle(syndFeed.getTitle().getValue());
        }
        if ((link = syndFeed.getLink("alternate")) != null && link.getHref() != null) {
            this.setLink(link.getHref());
        }
        if (syndFeed.getSubtitle() != null && syndFeed.getSubtitle().getValue() != null) {
            this.setDescription(syndFeed.getSubtitle().getValue());
        }
        if (syndFeed.getLang() != null) {
            this.setLanguage(syndFeed.getLang());
        }
        if (syndFeed.getRights() != null && syndFeed.getRights().getValue() != null) {
            this.setCopyright(syndFeed.getRights().getValue());
        }
        if (syndFeed.getAuthors().size() > 0 && (author = syndFeed.getAuthors().get(0)).getEmail() != null) {
            this.setManagingEditor(author.getEmail());
        }
        if (syndFeed.getUpdated() != null) {
            this.setLastBuildDate(RssChannel.convertJavaDateToRssDate(syndFeed.getUpdated()));
        }
        this.getCategories().clear();
        for (SyndCategory syndCategory : syndFeed.getCategories()) {
            this.getCategories().add(new RssCategory(syndCategory));
        }
        if (syndFeed.getGenerator() != null && syndFeed.getGenerator().getValue() != null) {
            this.setGenerator(syndFeed.getGenerator().getValue());
        }
        if (syndFeed.getLogo() != null) {
            RssImage rssImage = new RssImage();
            rssImage.setUrl(syndFeed.getLogo());
            rssImage.setTitle(this.getTitle());
            rssImage.setLink(this.getLink());
            this.setImage(rssImage);
        }
        this.getItems().clear();
        for (SyndEntry syndEntry : syndFeed.getEntries()) {
            RssItem rssItem = new RssItem(syndEntry);
            this.getItems().add(rssItem);
        }
    }

    public SyndFeed toSynd(SyndFeed syndFeed) {
        if (syndFeed == null) {
            return syndFeed;
        }
        if (this.getTitle() != null) {
            syndFeed.setTitle(new SyndText(this.getTitle(), SyndTextType.text));
        }
        if (this.getLink() != null) {
            SyndLink syndLink = new SyndLink();
            syndLink.setHref(this.getLink());
            syndLink.setRel("alternate");
            syndFeed.getLinks().add(syndLink);
        }
        if (this.getDescription() != null) {
            syndFeed.setSubtitle(new SyndText(this.getDescription(), SyndTextType.text));
        }
        if (this.getLanguage() != null) {
            syndFeed.setLang(this.getLanguage());
        }
        if (this.getCopyright() != null) {
            syndFeed.setRights(new SyndText(this.getCopyright()));
        }
        if (this.getManagingEditor() != null) {
            SyndPerson syndAuthor = new SyndPerson();
            String authorEmail = this.getManagingEditor();
            syndAuthor.setEmail(authorEmail);
            syndAuthor.setName(authorEmail.substring(0, authorEmail.indexOf("@")));
            syndFeed.getAuthors().add(syndAuthor);
        }
        if (this.getLastBuildDate() != null) {
            syndFeed.setUpdated(RssChannel.convertRssDateToJavaDate(this.getLastBuildDate()));
        }
        syndFeed.getCategories().clear();
        for (RssCategory rssCategory : this.getCategories()) {
            SyndCategory syndCategory = new SyndCategory();
            syndCategory = rssCategory.toSynd(syndCategory);
            syndFeed.getCategories().add(syndCategory);
        }
        if (this.getGenerator() != null) {
            syndFeed.setGenerator(new SyndGenerator(this.getGenerator()));
        }
        if (this.getImage() != null && this.getImage().getUrl() != null) {
            syndFeed.setLogo(this.getImage().getUrl());
        }
        syndFeed.getEntries().clear();
        for (RssItem rssItem : this.getItems()) {
            SyndEntry syndEntry = new SyndEntry();
            syndEntry = rssItem.toSynd(syndEntry);
            syndFeed.getEntries().add(syndEntry);
        }
        return syndFeed;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String value) {
        this.link = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String value) {
        this.language = value;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String value) {
        this.copyright = value;
    }

    public String getManagingEditor() {
        return this.managingEditor;
    }

    public void setManagingEditor(String value) {
        this.managingEditor = value;
    }

    public String getWebMaster() {
        return this.webMaster;
    }

    public void setWebMaster(String value) {
        this.webMaster = value;
    }

    public String getPubDate() {
        return this.pubDate;
    }

    public void setPubDate(String value) {
        this.pubDate = value;
    }

    public String getLastBuildDate() {
        return this.lastBuildDate;
    }

    public void setLastBuildDate(String value) {
        this.lastBuildDate = value;
    }

    public List<RssCategory> getCategories() {
        if (this.category == null) {
            this.category = new ArrayList<RssCategory>();
        }
        return this.category;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String value) {
        this.generator = value;
    }

    public String getDocs() {
        return this.docs;
    }

    public void setDocs(String value) {
        this.docs = value;
    }

    public RssCloud getCloud() {
        return this.cloud;
    }

    public void setCloud(RssCloud value) {
        this.cloud = value;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer value) {
        this.ttl = value;
    }

    public RssImage getImage() {
        return this.image;
    }

    public void setImage(RssImage value) {
        this.image = value;
    }

    public String getRating() {
        return this.rating;
    }

    public void setRating(String value) {
        this.rating = value;
    }

    public RssTextInput getTextInput() {
        return this.textInput;
    }

    public void setTextInput(RssTextInput value) {
        this.textInput = value;
    }

    public RssSkipHours getSkipHours() {
        return this.skipHours;
    }

    public void setSkipHours(RssSkipHours value) {
        this.skipHours = value;
    }

    public RssSkipDays getSkipDays() {
        return this.skipDays;
    }

    public void setSkipDays(RssSkipDays value) {
        this.skipDays = value;
    }

    public List<Object> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Object>();
        }
        return this.any;
    }

    public List<RssItem> getItems() {
        if (this.item == null) {
            this.item = new ArrayList<RssItem>();
        }
        return this.item;
    }

    public static String convertJavaDateToRssDate(Date javaDate) {
        SimpleDateFormat format = new SimpleDateFormat(RSS_DATE_FORMAT);
        return format.format(javaDate);
    }

    public static Date convertRssDateToJavaDate(String rssDate) {
        SimpleDateFormat format = new SimpleDateFormat(RSS_DATE_FORMAT);
        try {
            return format.parse(rssDate);
        }
        catch (ParseException e) {
            logger.error(Messages.getMessage("listExceptionDuringClassProcessing"), (Throwable)e);
            return null;
        }
    }
}

