/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.utils;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.core.PathSegment;
import plugin.rtc.org.apache.wink.common.internal.MultivaluedMapImpl;
import plugin.rtc.org.apache.wink.common.internal.PathSegmentImpl;
import plugin.rtc.org.apache.wink.common.internal.uri.UriEncoder;
import plugin.rtc.org.apache.wink.common.internal.uri.UriPathNormalizer;
import plugin.rtc.org.apache.wink.common.internal.utils.MediaTypeUtils;
import plugin.rtc.org.apache.wink.common.internal.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriHelper {
    private static final Logger logger = LoggerFactory.getLogger(UriHelper.class);

    private UriHelper() {
    }

    public static String removeTrailingSlash(String uri) {
        if (uri != null && uri.length() > 0 && uri.lastIndexOf(47) == uri.length() - 1) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    public static String stripQueryString(String requestUri) {
        int idx;
        if (requestUri != null && (idx = requestUri.lastIndexOf(63)) != -1) {
            requestUri = requestUri.substring(0, idx);
            return UriHelper.removeTrailingSlash(requestUri);
        }
        return requestUri;
    }

    public static String getQueryString(String requestUri) {
        int idx;
        if (requestUri != null && (idx = requestUri.lastIndexOf(63)) != -1) {
            return requestUri.substring(idx + 1, requestUri.length());
        }
        return null;
    }

    public static String stripName(String requestUri) {
        int idx;
        if (requestUri != null && (idx = (requestUri = UriHelper.removeTrailingSlash(requestUri)).lastIndexOf(47)) != -1) {
            return requestUri.substring(0, idx);
        }
        return null;
    }

    public static String getNameFromPath(String uri) {
        if (uri != null) {
            uri = UriHelper.removeTrailingSlash(uri);
            return uri.substring(uri.lastIndexOf(47) + 1, uri.length());
        }
        return null;
    }

    public static String hidePassword(URI url) {
        if (url == null) {
            return null;
        }
        String ui = url.getRawUserInfo();
        if (ui == null) {
            return url.toString();
        }
        String str = url.toString();
        int pidx = str.indexOf(ui);
        if (pidx < 0) {
            return str;
        }
        return str.substring(0, pidx) + str.substring(pidx + ui.length() + 1);
    }

    public static String hidePassword(String url) {
        if (url == null) {
            return null;
        }
        return UriHelper.hidePassword(URI.create(url));
    }

    public static List<String> hidePassword(List<String> urls) {
        if (urls == null) {
            return urls;
        }
        ArrayList<String> ret = new ArrayList<String>(urls.size());
        for (String url : urls) {
            ret.add(UriHelper.hidePassword(url));
        }
        return ret;
    }

    public static String relativize(String basePath, String pathToRelativize) {
        int pos;
        String normalizeBasePath = UriHelper.removeStartSlash(UriPathNormalizer.normalize(basePath));
        String[] splitBase = StringUtils.fastSplit(normalizeBasePath, "/", false);
        String normalizedPathToRelativize = UriHelper.removeStartSlash(UriPathNormalizer.normalize(pathToRelativize));
        String[] splitPath = StringUtils.fastSplit(normalizedPathToRelativize, "/", false);
        for (pos = 0; pos < splitBase.length && pos < splitPath.length && splitBase[pos].equals(splitPath[pos]); ++pos) {
        }
        StringBuilder result = new StringBuilder();
        if (pos == splitBase.length && !normalizeBasePath.endsWith("/")) {
            String lastSegment = splitBase[pos - 1];
            result.append(lastSegment);
            while (pos < splitPath.length) {
                if (result.length() != 0) {
                    result.append('/');
                }
                result.append(splitPath[pos]);
                ++pos;
            }
        } else if (pos == splitBase.length) {
            while (pos < splitPath.length) {
                if (result.length() != 0) {
                    result.append('/');
                }
                result.append(splitPath[pos]);
                ++pos;
            }
        } else {
            for (int posBase = pos; posBase < splitBase.length - 1; ++posBase) {
                if (result.length() != 0) {
                    result.append('/');
                }
                result.append("..");
            }
            if (normalizeBasePath.endsWith("/")) {
                if (result.length() != 0) {
                    result.append('/');
                }
                result.append("..");
            }
            while (pos < splitPath.length) {
                if (result.length() != 0) {
                    result.append('/');
                }
                result.append(splitPath[pos]);
                ++pos;
            }
        }
        if (result.length() == 0) {
            result.append('.');
        }
        return result.toString();
    }

    public static String removeStartSlash(String s) {
        if (s.startsWith("/")) {
            return s.substring(1);
        }
        return s;
    }

    public static String appendPathToBaseUri(String baseUri, String path) {
        boolean startSlash;
        if (baseUri == null) {
            throw new NullPointerException("baseUri");
        }
        if (path == null || path.length() == 0) {
            return baseUri;
        }
        boolean endSlash = baseUri.endsWith("/");
        boolean bl = startSlash = path.charAt(0) == '/';
        if (startSlash && endSlash) {
            return baseUri + path.substring(1);
        }
        if (startSlash || endSlash) {
            return baseUri + path;
        }
        return baseUri + '/' + path;
    }

    public static String appendAltToPath(String uri, MediaType mediaType) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (mediaType == null) {
            throw new NullPointerException("mediaType");
        }
        StringBuilder result = new StringBuilder(uri);
        if (uri.length() == 0) {
            result.append('.');
        }
        char appendCharacter = '?';
        if (uri.indexOf(63) != -1) {
            appendCharacter = '&';
        }
        result.append(appendCharacter);
        result.append("alt");
        result.append('=');
        result.append(MediaTypeUtils.toEncodedString(mediaType));
        return result.toString();
    }

    public static String contructUri(String scheme, String userInfo, String host, int port, String path, String query2, String fragment) {
        StringBuilder buffer = new StringBuilder();
        if (scheme != null) {
            buffer.append(scheme);
            buffer.append("://");
        }
        if (userInfo != null) {
            buffer.append(userInfo);
            buffer.append("@");
        }
        if (host != null) {
            buffer.append(host);
        }
        if (port != -1) {
            buffer.append(":");
            buffer.append(port);
        }
        if (path != null) {
            buffer.append(path);
        }
        if (query2 != null) {
            buffer.append("?");
            buffer.append(query2);
        }
        if (fragment != null) {
            buffer.append("#");
            buffer.append(fragment);
        }
        return buffer.toString();
    }

    public static String getQueryParamsStr(Map<String, String[]> queryParams, boolean escapeKeyParam) {
        if (queryParams == null || queryParams.size() < 1) {
            return "";
        }
        StringBuilder queryParamsStr = new StringBuilder();
        Set<String> queryParamsKey = queryParams.keySet();
        String appendStr = "";
        for (String key : queryParamsKey) {
            String[] params = queryParams.get(key);
            if (params == null) continue;
            for (String paramInArray : params) {
                queryParamsStr.append(appendStr);
                queryParamsStr.append(escapeKeyParam ? UriEncoder.encodeString(key) : key).append("=").append(escapeKeyParam ? UriEncoder.encodeString(paramInArray) : paramInArray);
                appendStr = "&";
            }
        }
        return queryParamsStr.toString();
    }

    public static String appendQueryParamsToPath(String uri, Map<String, String[]> queryParams, boolean escapeKeyParam) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (queryParams == null || queryParams.size() < 1) {
            return uri;
        }
        StringBuilder result = new StringBuilder(uri);
        if (uri.length() == 0) {
            result.append('.');
        }
        char appendCharacter = '?';
        if (uri.indexOf(63) != -1) {
            appendCharacter = '&';
        }
        return uri + appendCharacter + UriHelper.getQueryParamsStr(queryParams, escapeKeyParam);
    }

    public static List<PathSegment> parsePath(String path) {
        logger.trace("parsePath({}) entry", (Object)path);
        String[] segmentsArray = StringUtils.fastSplitTemplate(path, "/", true);
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>(segmentsArray.length);
        for (String segment : segmentsArray) {
            pathSegments.add(new PathSegmentImpl(segment));
        }
        logger.trace("parsePath() exit returning {}", pathSegments);
        return pathSegments;
    }

    public static MultivaluedMap<String, String> parseQuery(String queryStr) {
        String[] paramsArray;
        MultivaluedMapImpl<String, String> query2 = new MultivaluedMapImpl<String, String>();
        if (queryStr == null || queryStr.length() == 0) {
            return query2;
        }
        for (String param : paramsArray = StringUtils.fastSplit(queryStr, "&")) {
            int index = param.indexOf(61);
            String name = param;
            String value = null;
            if (index != -1) {
                name = param.substring(0, index);
                value = param.substring(index + 1);
            }
            query2.add(name, value);
        }
        return query2;
    }

    public static String normalize(String uri) {
        uri = UriPathNormalizer.normalize(uri);
        uri = UriEncoder.normalize(uri);
        return uri;
    }
}

