/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.uritemplate;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.core.PathSegment;
import plugin.rtc.org.apache.wink.common.internal.MultivaluedMapImpl;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;
import plugin.rtc.org.apache.wink.common.internal.uri.UriEncoder;
import plugin.rtc.org.apache.wink.common.internal.uritemplate.UriTemplateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriTemplateMatcher {
    protected UriTemplateProcessor parent;
    protected String uri;
    protected Matcher matcher;
    protected boolean matches;
    private MultivaluedMap<String, String> variables;
    private MultivaluedMap<String, Integer> variablesStartIndices;
    private MultivaluedMap<String, List<PathSegment>> variablesPathSegments;

    public String toString() {
        return String.format("Parent: %s; URI: %s; Matcher: %s; Matches: %b", this.parent, this.uri, this.matcher, this.matches);
    }

    UriTemplateMatcher(UriTemplateProcessor parent) {
        this.parent = parent;
        this.uri = null;
        this.matcher = null;
        this.matches = false;
        this.variables = null;
        this.variablesStartIndices = null;
        this.variablesPathSegments = null;
    }

    public UriTemplateProcessor getProcessor() {
        return this.parent;
    }

    public MultivaluedMap<String, String> match(String uri) {
        return this.match(uri, false);
    }

    public MultivaluedMap<String, String> match(String uri, boolean decode) {
        if (!this.matches(uri)) {
            return null;
        }
        return this.getVariables(decode);
    }

    public boolean matches(String uri) {
        if (uri == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "uri"));
        }
        this.uri = uri;
        this.variables = null;
        this.variablesStartIndices = null;
        this.variablesPathSegments = null;
        this.matcher = this.parent.getPattern().matcher(uri);
        this.matches = this.matcher.matches();
        return this.matches;
    }

    public boolean isExactMatch() {
        this.assertMatchState();
        String tail = this.getTail();
        return tail == null || tail.length() == 0 || tail.equals("/");
    }

    public String getTail() {
        return this.getTail(true);
    }

    public String getTail(boolean decode) {
        this.assertMatchState();
        if (this.parent.tail == null) {
            return "";
        }
        String value = this.matcher.group(this.parent.tail.getCapturingGroupId());
        if (decode) {
            value = UriEncoder.decodeString(value);
        }
        return value;
    }

    public String getHead() {
        return this.getHead(true);
    }

    public String getHead(boolean decode) {
        this.assertMatchState();
        if (this.parent.head == null) {
            return this.uri;
        }
        String head = this.matcher.group(this.parent.head.getCapturingGroupId());
        if (decode) {
            head = UriEncoder.decodeString(head);
        }
        String tail = this.getTail(false);
        if (this.parent.template.endsWith("/") && tail != null && tail.equals("/")) {
            head = head + tail;
        }
        return head;
    }

    public String getVariableValue(String name) throws IllegalStateException {
        return this.getVariableValue(name, true);
    }

    public String getVariableValue(String name, boolean decode) throws IllegalStateException {
        List<String> list = this.getVariableValues(name, decode);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<String> getVariableValues(String name) throws IllegalStateException {
        return this.getVariableValues(name, true);
    }

    public List<String> getVariableValues(String name, boolean decode) throws IllegalStateException {
        if (name == null) {
            return new ArrayList<String>();
        }
        MultivaluedMap<String, String> variables = this.getVariables(decode);
        List values = (List)variables.get(name);
        if (values == null) {
            return new ArrayList<String>();
        }
        return values;
    }

    public MultivaluedMap<String, String> getVariables() throws IllegalStateException {
        return this.getVariables(false);
    }

    public MultivaluedMap<String, String> getVariables(boolean decode) throws IllegalStateException {
        return this.storeVariables(null, decode);
    }

    public MultivaluedMap<String, String> storeVariables(MultivaluedMap<String, String> out, boolean decode) throws IllegalStateException {
        this.assertMatchState();
        this.buildVariables();
        if (out == null) {
            out = new MultivaluedMapImpl<String, String>();
        }
        MultivaluedMapImpl.addAll(this.variables, out);
        if (decode) {
            this.decodeValues(out);
        }
        return out;
    }

    public MultivaluedMap<String, List<PathSegment>> storeVariablesPathSegments(List<PathSegment> segments, int offset, int count, MultivaluedMap<String, List<PathSegment>> out) throws IllegalStateException {
        this.assertMatchState();
        this.buildVariablesPathSegments(segments, offset, count);
        if (out == null) {
            out = new MultivaluedMapImpl<String, List<PathSegment>>();
        }
        MultivaluedMapImpl.addAll(this.variablesPathSegments, out);
        return out;
    }

    private void buildVariables() {
        if (this.variables != null) {
            return;
        }
        this.variables = new MultivaluedMapImpl<String, String>();
        this.variablesStartIndices = new MultivaluedMapImpl<String, Integer>();
        MultivaluedMap<String, UriTemplateProcessor.CapturingGroup> variableGroups = this.parent.getVariables();
        for (String name : variableGroups.keySet()) {
            List vars = (List)variableGroups.get(name);
            for (UriTemplateProcessor.CapturingGroup var : vars) {
                int group = var.getCapturingGroupId();
                String matched = this.matcher.group(group);
                int startIndex = this.matcher.start(group);
                var.onMatch(matched, this.variables, startIndex, this.variablesStartIndices);
            }
        }
    }

    private void buildVariablesPathSegments(List<PathSegment> segments, int offset, int count) {
        if (this.variablesPathSegments != null) {
            return;
        }
        this.buildVariables();
        this.variablesPathSegments = new MultivaluedMapImpl<String, List<PathSegment>>();
        for (String name : this.variables.keySet()) {
            for (int i = 0; i < ((List)this.variables.get(name)).size(); ++i) {
                String variableValue = (String)((List)this.variables.get(name)).get(i);
                if (variableValue == null) continue;
                int variableValueStartIndex = (Integer)((List)this.variablesStartIndices.get(name)).get(i);
                LinkedList<PathSegment> variableSegments = new LinkedList<PathSegment>();
                int pathLength = 0;
                for (int segmentIndex = offset; segmentIndex < offset + count; ++segmentIndex) {
                    if (variableValueStartIndex < (pathLength += segments.get(segmentIndex).getPath().length())) {
                        int lastSegmentIndex = segmentIndex;
                        int variableValueEndIndex = variableValueStartIndex + variableValue.length() - 1;
                        while (variableValueEndIndex > pathLength) {
                            pathLength += segments.get(++lastSegmentIndex).getPath().length() + 1;
                        }
                        while (segmentIndex <= lastSegmentIndex) {
                            variableSegments.add(segments.get(segmentIndex));
                            ++segmentIndex;
                        }
                        break;
                    }
                    if (variableValueStartIndex == pathLength) {
                        variableSegments.add(segments.get(segmentIndex));
                        break;
                    }
                    ++pathLength;
                }
                this.variablesPathSegments.add(name, variableSegments);
            }
        }
    }

    protected MultivaluedMap<String, String> decodeValues(MultivaluedMap<String, String> values) {
        for (List list : values.values()) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, UriEncoder.decodeString((String)list.get(i)));
            }
        }
        return values;
    }

    protected void assertMatchState() {
        if (!this.matches) {
            throw new IllegalStateException(Messages.getMessage("lastMatchWasUnsuccessful"));
        }
    }
}

