/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.providers.entity.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.javax.ws.rs.Consumes;
import plugin.rtc.javax.ws.rs.Produces;
import plugin.rtc.javax.ws.rs.WebApplicationException;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.core.Response;
import plugin.rtc.javax.ws.rs.ext.MessageBodyReader;
import plugin.rtc.javax.ws.rs.ext.MessageBodyWriter;
import plugin.rtc.javax.ws.rs.ext.Provider;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;
import plugin.rtc.org.apache.wink.common.internal.providers.entity.xml.AbstractJAXBProvider;
import plugin.rtc.org.apache.wink.common.internal.providers.entity.xml.EntityReferenceXMLStreamException;
import plugin.rtc.org.apache.wink.common.internal.utils.MediaTypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"text/xml", "application/xml", "*/*"})
@Produces(value={"text/xml", "application/xml", "*/*"})
public class JAXBXmlProvider
extends AbstractJAXBProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(JAXBXmlProvider.class);

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return (JAXBXmlProvider.isJAXBObject(type, genericType) || this.isCompatible(type, annotations)) && this.isSupportedMediaType(mediaType);
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Class<?> concreteType = this.getConcreteTypeFromTypeMap(type, annotations);
        Unmarshaller unmarshaller = null;
        Object unmarshaledResource = null;
        XMLStreamReader xmlStreamReader = null;
        try {
            JAXBContext context = this.getContext(concreteType, mediaType);
            unmarshaller = this.getJAXBUnmarshaller(concreteType, context, mediaType);
            xmlStreamReader = this.getXMLStreamReader(entityStream);
            if (concreteType.isAnnotationPresent(XmlRootElement.class)) {
                unmarshaledResource = unmarshaller.unmarshal(xmlStreamReader);
                JAXBXmlProvider.closeXMLStreamReader(xmlStreamReader);
                if (unmarshaledResource instanceof JAXBElement) {
                    unmarshaledResource = ((JAXBElement)unmarshaledResource).getValue();
                }
            } else {
                try {
                    final Unmarshaller _unmarshaller = unmarshaller;
                    final XMLStreamReader _xmlStreamReader = xmlStreamReader;
                    final Class<?> _concreteType = concreteType;
                    unmarshaledResource = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws PrivilegedActionException {
                            try {
                                Object obj = _unmarshaller.unmarshal(_xmlStreamReader, _concreteType).getValue();
                                AbstractJAXBProvider.closeXMLStreamReader(_xmlStreamReader);
                                return obj;
                            }
                            catch (JAXBException e) {
                                throw new PrivilegedActionException((Exception)((Object)e));
                            }
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    JAXBXmlProvider.closeXMLStreamReader(xmlStreamReader);
                    if (logger.isErrorEnabled()) {
                        logger.error(Messages.getMessage("jaxbFailToUnmarshal", concreteType.getName()), (Throwable)e.getException());
                    }
                    throw new WebApplicationException((Throwable)e.getException(), Response.Status.BAD_REQUEST);
                }
            }
            this.releaseJAXBUnmarshaller(context, unmarshaller);
        }
        catch (JAXBException e) {
            JAXBXmlProvider.closeXMLStreamReader(xmlStreamReader);
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("jaxbFailToUnmarshal", concreteType.getName()), (Throwable)e);
            }
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (EntityReferenceXMLStreamException e) {
            JAXBXmlProvider.closeXMLStreamReader(xmlStreamReader);
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("entityRefsNotSupported"));
            }
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (XMLStreamException e) {
            JAXBXmlProvider.closeXMLStreamReader(xmlStreamReader);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (RuntimeException e) {
            JAXBXmlProvider.closeXMLStreamReader(xmlStreamReader);
            throw e;
        }
        return this.unmarshalWithXmlAdapter(unmarshaledResource, type, type, annotations);
    }

    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return (JAXBXmlProvider.isJAXBObject(type, genericType) || this.isCompatible(type, annotations)) && this.isSupportedMediaType(mediaType);
    }

    @Override
    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        t = this.marshalWithXmlAdapter(t, type, genericType, annotations);
        Class<?> concreteType = this.getConcreteTypeFromTypeMap(type, annotations);
        mediaType = MediaTypeUtils.setDefaultCharsetOnMediaTypeHeader(httpHeaders, mediaType);
        try {
            if (JAXBXmlProvider.isJAXBObject(concreteType)) {
                JAXBContext context = this.getContext(concreteType, genericType, mediaType);
                if (logger.isTraceEnabled()) {
                    logger.trace("using context {}@{} to get marshaller", (Object)context.getClass().getName(), (Object)System.identityHashCode(context));
                }
                Marshaller marshaller = this.getJAXBMarshaller(concreteType, context, mediaType);
                Object entityToMarshal = this.getEntityToMarshal(t, concreteType);
                marshaller.marshal(entityToMarshal, entityStream);
                this.releaseJAXBMarshaller(context, marshaller);
            } else if (genericType instanceof Class) {
                JAXBContext context = this.getContext((Class)genericType, genericType, mediaType);
                Marshaller marshaller = this.getJAXBMarshaller((Class)genericType, context, mediaType);
                Object entityToMarshal = this.getEntityToMarshal(t, (Class)genericType);
                marshaller.marshal(entityToMarshal, entityStream);
                this.releaseJAXBMarshaller(context, marshaller);
            }
        }
        catch (JAXBException e) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("jaxbFailToMarshal", concreteType.getName()), (Throwable)e);
            }
            throw new WebApplicationException(e);
        }
    }
}

