/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.http;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import plugin.rtc.javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptLanguage {
    private static final RuntimeDelegate.HeaderDelegate<AcceptLanguage> delegate = RuntimeDelegate.getInstance().createHeaderDelegate(AcceptLanguage.class);
    private final String acceptLanguageHeader;
    private final boolean anyAllowed;
    private final List<Locale> acceptable;
    private final List<Locale> banned;
    private final List<ValuedLocale> valuedLocales;

    public AcceptLanguage(String acceptLanguageValue, List<Locale> acceptableLanguages, List<Locale> bannedLanguages, boolean anyLanguageAllowed, List<ValuedLocale> valuedLocales) {
        this.acceptLanguageHeader = acceptLanguageValue;
        this.anyAllowed = anyLanguageAllowed;
        this.acceptable = Collections.unmodifiableList(acceptableLanguages);
        this.banned = Collections.unmodifiableList(bannedLanguages);
        this.valuedLocales = Collections.unmodifiableList(valuedLocales);
    }

    public List<Locale> getAcceptableLanguages() {
        return this.acceptable;
    }

    public boolean isAnyLanguageAllowed() {
        return this.anyAllowed;
    }

    public List<Locale> getBannedLanguages() {
        return this.banned;
    }

    public static AcceptLanguage valueOf(String value) throws IllegalArgumentException {
        return delegate.fromString(value);
    }

    public String getAcceptLanguageHeader() {
        return this.acceptLanguageHeader;
    }

    public List<ValuedLocale> getValuedLocales() {
        return this.valuedLocales;
    }

    public String toString() {
        return delegate.toString(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ValuedLocale
    implements Comparable<ValuedLocale> {
        public final double qValue;
        public final Locale locale;

        public ValuedLocale(double qValue, Locale locale) {
            this.qValue = qValue;
            this.locale = locale;
        }

        @Override
        public int compareTo(ValuedLocale other) {
            return Double.compare(this.qValue, other.qValue);
        }

        public boolean isWildcard() {
            return this.locale == null;
        }
    }
}

