/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.net.oauth.signature.pem;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import plugin.rtc.net.oauth.signature.OAuthSignatureMethod;

public class PEMReader {
    public static final String PRIVATE_PKCS1_MARKER = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String PRIVATE_PKCS8_MARKER = "-----BEGIN PRIVATE KEY-----";
    public static final String CERTIFICATE_X509_MARKER = "-----BEGIN CERTIFICATE-----";
    public static final String PUBLIC_X509_MARKER = "-----BEGIN PUBLIC KEY-----";
    private static final String BEGIN_MARKER = "-----BEGIN ";
    private InputStream stream;
    private byte[] derBytes;
    private String beginMarker;

    public PEMReader(InputStream inStream) throws IOException {
        this.stream = inStream;
        this.readFile();
    }

    public PEMReader(byte[] buffer) throws IOException {
        this(new ByteArrayInputStream(buffer));
    }

    public PEMReader(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public byte[] getDerBytes() {
        return this.derBytes;
    }

    public String getBeginMarker() {
        return this.beginMarker;
    }

    protected void readFile() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(BEGIN_MARKER) == -1) continue;
                this.beginMarker = line.trim();
                String endMarker = this.beginMarker.replace("BEGIN", "END");
                this.derBytes = this.readBytes(reader, endMarker);
                return;
            }
            throw new IOException("Invalid PEM file: no begin marker");
        }
        finally {
            reader.close();
        }
    }

    private byte[] readBytes(BufferedReader reader, String endMarker) throws IOException {
        String line = null;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(endMarker) != -1) {
                return OAuthSignatureMethod.decodeBase64(buf.toString());
            }
            buf.append(line.trim());
        }
        throw new IOException("Invalid PEM file: No end marker");
    }
}

