/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.shared.uuid;

import java.util.Locale;
import java.util.Random;
import plugin.rtc.com.hp.hpl.jena.shared.uuid.Bits;
import plugin.rtc.com.hp.hpl.jena.shared.uuid.JenaUUID;
import plugin.rtc.com.hp.hpl.jena.shared.uuid.LibUUID;
import plugin.rtc.com.hp.hpl.jena.shared.uuid.UUIDFactory;
import plugin.rtc.com.hp.hpl.jena.shared.uuid.UUID_V4;

public class UUID_V4_Gen
implements UUIDFactory {
    static final int versionHere = 4;
    static final int variantHere = 2;
    private Random random = null;

    @Override
    public JenaUUID generate() {
        return this.generateV4();
    }

    public UUID_V4 generateV4() {
        this.init();
        long mostSigBits = this.random.nextLong();
        long leastSigBits = this.random.nextLong();
        mostSigBits = Bits.pack(mostSigBits, 4L, 12, 16);
        leastSigBits = Bits.pack(leastSigBits, 2L, 62, 64);
        return new UUID_V4(mostSigBits, leastSigBits);
    }

    @Override
    public JenaUUID parse(String s) {
        return this.parseV4(s);
    }

    public UUID_V4 parseV4(String s) {
        if ((s = s.toLowerCase(Locale.ENGLISH)).length() != 36) {
            throw new JenaUUID.UUIDFormatException("UUID string is not 36 chars long: it's " + s.length() + " [" + s + "]");
        }
        if (s.charAt(8) != '-' && s.charAt(13) != '-' && s.charAt(18) != '-' && s.charAt(23) != '-') {
            throw new JenaUUID.UUIDFormatException("String does not have dashes in the right places: " + s);
        }
        UUID_V4 u = UUID_V4_Gen.parse$(s);
        if (u.getVersion() != 4) {
            throw new JenaUUID.UUIDFormatException("Wrong version (Expected: 4Got: " + u.getVersion() + "): " + s);
        }
        if (u.getVariant() != 2) {
            throw new JenaUUID.UUIDFormatException("Wrong version (Expected: 2Got: " + u.getVariant() + "): " + s);
        }
        return u;
    }

    static UUID_V4 parse$(String s) {
        long mostSigBits = Bits.unpack(s, 0, 8);
        mostSigBits = mostSigBits << 16 | Bits.unpack(s, 9, 13);
        mostSigBits = mostSigBits << 16 | Bits.unpack(s, 14, 18);
        long leastSigBits = Bits.unpack(s, 19, 23);
        leastSigBits = leastSigBits << 48 | Bits.unpack(s, 24, 36);
        return new UUID_V4(mostSigBits, leastSigBits);
    }

    private void init() {
        if (this.random == null) {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.random = LibUUID.makeRandom();
    }
}

