/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.reasoner.transitiveReasoner;

import plugin.rtc.com.hp.hpl.jena.graph.Capabilities;
import plugin.rtc.com.hp.hpl.jena.graph.Graph;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.graph.Triple;
import plugin.rtc.com.hp.hpl.jena.reasoner.BaseInfGraph;
import plugin.rtc.com.hp.hpl.jena.reasoner.FGraph;
import plugin.rtc.com.hp.hpl.jena.reasoner.Finder;
import plugin.rtc.com.hp.hpl.jena.reasoner.FinderUtil;
import plugin.rtc.com.hp.hpl.jena.reasoner.ReasonerException;
import plugin.rtc.com.hp.hpl.jena.reasoner.TriplePattern;
import plugin.rtc.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import plugin.rtc.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.UniqueFilter;

public class TransitiveInfGraph
extends BaseInfGraph {
    protected TransitiveEngine transitiveEngine;
    protected Finder tbox = null;
    protected Finder dataFind;

    public TransitiveInfGraph(Graph data, TransitiveReasoner reasoner) {
        super(data, reasoner);
    }

    @Override
    public synchronized void prepare() {
        if (this.isPrepared()) {
            return;
        }
        this.tbox = ((TransitiveReasoner)this.reasoner).getTbox();
        this.transitiveEngine = new TransitiveEngine(((TransitiveReasoner)this.reasoner).getSubClassCache().deepCopy(), ((TransitiveReasoner)this.reasoner).getSubPropertyCache().deepCopy());
        this.dataFind = this.transitiveEngine.insert(this.tbox, this.fdata);
        this.transitiveEngine.setCaching(true, true);
        this.setPreparedState(true);
    }

    @Override
    public Graph getSchemaGraph() {
        if (this.tbox == null) {
            return null;
        }
        if (this.tbox instanceof FGraph) {
            return ((FGraph)this.tbox).getGraph();
        }
        throw new ReasonerException("Transitive reasoner got into an illegal state");
    }

    @Override
    public ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        this.requirePrepared();
        Finder cascade = this.transitiveEngine.getFinder(pattern, FinderUtil.cascade(this.tbox, continuation));
        return cascade.find(pattern).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), this.fdata);
    }

    @Override
    public ExtendedIterator<Triple> find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, this.fdata);
    }

    @Override
    public synchronized void performAdd(Triple t) {
        this.requirePrepared();
        this.fdata.getGraph().add(t);
        this.transitiveEngine.add(t);
    }

    @Override
    public synchronized void performDelete(Triple t) {
        this.fdata.getGraph().delete(t);
        if (this.isPrepared()) {
            this.transitiveEngine.delete(t);
        }
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfFindSafeCapabilities();
        }
        return this.capabilities;
    }
}

