/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.reasoner.TriplePattern;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.Functor;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.Rule;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.impl.RuleClauseCode;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.impl.RuleStore;

public class LPRuleStore
extends RuleStore {
    protected boolean isCompiled = false;
    protected Map<Node, List<RuleClauseCode>> predicateToCodeMap;
    protected ArrayList<RuleClauseCode> allRuleClauseCodes;
    protected Map<Node, Map<Node, List<RuleClauseCode>>> indexPredicateToCodeMap;
    protected HashSet<Node> tabledPredicates = new HashSet();
    private static final int INDEX_THRESHOLD = 20;
    protected boolean allTabled = false;

    public LPRuleStore(List<Rule> rules) {
        super(rules);
    }

    public LPRuleStore() {
    }

    public void addAll(LPRuleStore store) {
        super.addAll(store);
        this.tabledPredicates.addAll(store.tabledPredicates);
        this.allTabled = this.tabledPredicates.contains(Node.ANY);
    }

    public synchronized void tablePredicate(Node predicate) {
        this.tabledPredicates.add(predicate);
        if (predicate == Node.ANY) {
            this.allTabled = true;
        }
    }

    public List<RuleClauseCode> codeFor(Node predicate) {
        if (!this.isCompiled) {
            this.compileAll();
        }
        if (predicate.isVariable()) {
            return this.allRuleClauseCodes;
        }
        List<RuleClauseCode> codeList = this.predicateToCodeMap.get(predicate);
        if (codeList == null) {
            codeList = this.predicateToCodeMap.get(Node_RuleVariable.WILD);
        }
        return codeList;
    }

    public List<RuleClauseCode> codeFor(TriplePattern goal) {
        List<RuleClauseCode> indexedCode;
        List<RuleClauseCode> allRules = this.codeFor(goal.getPredicate());
        if (allRules == null) {
            return allRules;
        }
        Map<Node, List<RuleClauseCode>> indexedCodeTable = this.indexPredicateToCodeMap.get(goal.getPredicate());
        if (indexedCodeTable != null && (indexedCode = indexedCodeTable.get(goal.getObject())) != null) {
            return indexedCode;
        }
        return allRules;
    }

    public boolean isIndexedPredicate(Node predicate) {
        return this.indexPredicateToCodeMap.get(predicate) != null;
    }

    public boolean isTabled(TriplePattern goal) {
        return this.isTabled(goal.getPredicate());
    }

    public boolean isTabled(Node predicate) {
        if (this.allTabled) {
            return true;
        }
        if (predicate.isVariable() && !this.tabledPredicates.isEmpty()) {
            return true;
        }
        return this.tabledPredicates.contains(predicate);
    }

    protected void compileAll() {
        Node predicate;
        this.isCompiled = true;
        this.predicateToCodeMap = new HashMap<Node, List<RuleClauseCode>>();
        this.allRuleClauseCodes = new ArrayList();
        this.indexPredicateToCodeMap = new HashMap<Node, Map<Node, List<RuleClauseCode>>>();
        for (Rule r : this.getAllRules()) {
            List<RuleClauseCode> predicateCode;
            ClauseEntry clauseEntry = r.getHeadElement(0);
            if (!(clauseEntry instanceof TriplePattern)) continue;
            RuleClauseCode code = new RuleClauseCode(r);
            this.allRuleClauseCodes.add(code);
            Node predicate2 = ((TriplePattern)clauseEntry).getPredicate();
            if (predicate2.isVariable()) {
                predicate2 = Node_RuleVariable.WILD;
            }
            if ((predicateCode = this.predicateToCodeMap.get(predicate2)) == null) {
                predicateCode = new ArrayList<RuleClauseCode>();
                this.predicateToCodeMap.put(predicate2, predicateCode);
            }
            predicateCode.add(code);
            if (predicateCode.size() <= 20) continue;
            this.indexPredicateToCodeMap.put(predicate2, new HashMap());
        }
        List<RuleClauseCode> wildRules = this.predicateToCodeMap.get(Node_RuleVariable.WILD);
        if (wildRules != null) {
            for (Map.Entry<Node, List<RuleClauseCode>> entry : this.predicateToCodeMap.entrySet()) {
                predicate = entry.getKey();
                List<RuleClauseCode> predicateCode = entry.getValue();
                if (predicate == Node_RuleVariable.WILD) continue;
                predicateCode.addAll(wildRules);
            }
        }
        this.indexPredicateToCodeMap.put(Node_RuleVariable.WILD, new HashMap());
        for (Map.Entry<Node, Object> entry : this.indexPredicateToCodeMap.entrySet()) {
            predicate = entry.getKey();
            Map predicateMap = (Map)entry.getValue();
            ArrayList<RuleClauseCode> wildRulesForPredicate = new ArrayList<RuleClauseCode>();
            ArrayList<RuleClauseCode> allRulesForPredicate = predicate.isVariable() ? this.allRuleClauseCodes : this.predicateToCodeMap.get(predicate);
            for (RuleClauseCode code : allRulesForPredicate) {
                Node objectPattern;
                ClauseEntry head = code.getRule().getHeadElement(0);
                boolean indexed = false;
                if (head instanceof TriplePattern && !(objectPattern = ((TriplePattern)head).getObject()).isVariable() && !Functor.isFunctor(objectPattern)) {
                    ArrayList<RuleClauseCode> indexedCode = (ArrayList<RuleClauseCode>)predicateMap.get(objectPattern);
                    if (indexedCode == null) {
                        indexedCode = new ArrayList<RuleClauseCode>();
                        predicateMap.put(objectPattern, indexedCode);
                    }
                    indexedCode.add(code);
                    indexed = true;
                }
                if (indexed) continue;
                wildRulesForPredicate.add(code);
            }
            for (Map.Entry ent : predicateMap.entrySet()) {
                Node pred = (Node)ent.getKey();
                List predicateCode = (List)ent.getValue();
                predicateCode.addAll(wildRulesForPredicate);
            }
        }
        for (RuleClauseCode ruleClauseCode : this.allRuleClauseCodes) {
            ruleClauseCode.compile(this);
        }
    }

    @Override
    protected void doAddRemoveRule(Rule rule, boolean isAdd) {
        this.isCompiled = false;
        super.doAddRemoveRule(rule, isAdd);
    }
}

