/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.reasoner;

import plugin.rtc.com.hp.hpl.jena.graph.Triple;
import plugin.rtc.com.hp.hpl.jena.reasoner.FGraph;
import plugin.rtc.com.hp.hpl.jena.reasoner.Finder;
import plugin.rtc.com.hp.hpl.jena.reasoner.TriplePattern;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class FinderUtil {
    public static Finder cascade(Finder first, Finder second) {
        if (first == null || first instanceof FGraph && ((FGraph)first).getGraph() == null) {
            return second;
        }
        if (second == null || second instanceof FGraph && ((FGraph)second).getGraph() == null) {
            return first;
        }
        return new Cascade(first, second);
    }

    public static Finder cascade(Finder first, Finder second, Finder third) {
        return new Cascade(first, FinderUtil.cascade(second, third));
    }

    public static Finder cascade(Finder first, Finder second, Finder third, Finder fourth) {
        return new Cascade(first, FinderUtil.cascade(second, FinderUtil.cascade(third, fourth)));
    }

    private static class Cascade
    implements Finder {
        Finder first;
        Finder second;

        Cascade(Finder first, Finder second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public ExtendedIterator<Triple> find(TriplePattern pattern) {
            if (this.second == null) {
                return this.first.find(pattern);
            }
            if (this.first == null) {
                return this.second.find(pattern);
            }
            return this.first.findWithContinuation(pattern, this.second);
        }

        @Override
        public ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder continuation) {
            return FinderUtil.cascade(this.first, this.second, continuation).find(pattern);
        }

        @Override
        public boolean contains(TriplePattern pattern) {
            ExtendedIterator<Triple> it = this.find(pattern);
            boolean result = it.hasNext();
            it.close();
            return result;
        }
    }
}

