/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.rdfxml.xmlinput.states;

import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import plugin.rtc.com.hp.hpl.jena.rdfxml.xmlinput.impl.ANode;
import plugin.rtc.com.hp.hpl.jena.rdfxml.xmlinput.impl.ARPResource;
import plugin.rtc.com.hp.hpl.jena.rdfxml.xmlinput.impl.AbsXMLContext;
import plugin.rtc.com.hp.hpl.jena.rdfxml.xmlinput.impl.AttributeLexer;
import plugin.rtc.com.hp.hpl.jena.rdfxml.xmlinput.impl.ElementLexer;
import plugin.rtc.com.hp.hpl.jena.rdfxml.xmlinput.impl.URIReference;
import plugin.rtc.com.hp.hpl.jena.rdfxml.xmlinput.impl.XMLHandler;
import plugin.rtc.com.hp.hpl.jena.rdfxml.xmlinput.states.Frame;
import plugin.rtc.com.hp.hpl.jena.rdfxml.xmlinput.states.FrameI;
import plugin.rtc.com.hp.hpl.jena.rdfxml.xmlinput.states.HasSubjectFrameI;
import plugin.rtc.com.hp.hpl.jena.rdfxml.xmlinput.states.WantPropertyElement;

public abstract class WantDescription
extends Frame
implements HasSubjectFrameI {
    ANode subject;
    boolean subjectIsBlank = false;

    public WantDescription(FrameI s, AbsXMLContext x) {
        super(s, x);
    }

    public WantDescription(FrameI s, AttributeLexer x) throws SAXParseException {
        super(s, x);
    }

    public WantDescription(XMLHandler handler, AbsXMLContext x) {
        super(handler, x);
    }

    @Override
    public FrameI startElement(String uri, String localName, String rawName, Attributes atts) throws SAXParseException {
        this.clearSubject();
        if (uri == null || uri.equals("")) {
            this.warning(104, "Unqualified typed nodes are not allowed. Type treated as a relative URI.");
        }
        AttributeLexer ap = new AttributeLexer(this, 575, 32248);
        ap.processSpecials(this.taint, atts);
        AbsXMLContext x = ap.xml(this.xml);
        if (ap.id != null) {
            this.subject = URIReference.fromID(this, x, ap.id);
        }
        if (ap.about != null) {
            if (this.subject != null) {
                this.warning(201, "Both ID and about");
            }
            this.subject = URIReference.resolve(this, x, ap.about);
        }
        if (ap.nodeID != null) {
            if (this.subject != null) {
                if (ap.about != null) {
                    this.warning(201, "Both nodeID and about");
                }
                if (ap.id != null) {
                    this.warning(201, "Both ID and nodeID");
                }
            }
            this.subject = new ARPResource(this.arp, ap.nodeID);
            this.checkXMLName(this.subject, ap.nodeID);
            this.subjectIsBlank = true;
        }
        if (this.subject == null) {
            this.subject = new ARPResource(this.arp);
            this.subjectIsBlank = true;
        }
        ElementLexer el = new ElementLexer(this.taint, this, uri, localName, rawName, 8192, 24056, true);
        if (this.taint.isTainted()) {
            this.subject.taint();
        }
        if (!el.goodMatch) {
            URIReference type = URIReference.fromQName(this, uri, localName);
            if (el.badMatch && this.taint.isTainted()) {
                type.taint();
            }
            this.triple(this.subject, RDF_TYPE, type);
        }
        this.processPropertyAttributes(ap, atts, x);
        return new WantPropertyElement(this, x);
    }

    private void clearSubject() {
        if (this.subjectIsBlank) {
            this.arp.endLocalScope(this.subject);
        }
        this.subject = null;
        this.subjectIsBlank = false;
    }

    @Override
    public void aPredAndObj(ANode p, ANode o) {
        this.triple(this.subject, p, o);
    }

    @Override
    public void makeSubjectReificationWith(ANode r) {
        this.triple(r, RDF_SUBJECT, this.subject);
    }

    @Override
    public void endElement() throws SAXParseException {
        this.clearSubject();
    }

    @Override
    public void abort() {
        this.clearSubject();
    }
}

