/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.rdf.model.impl;

import plugin.rtc.com.hp.hpl.jena.enhanced.EnhGraph;
import plugin.rtc.com.hp.hpl.jena.enhanced.EnhNode;
import plugin.rtc.com.hp.hpl.jena.enhanced.Implementation;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.graph.Triple;
import plugin.rtc.com.hp.hpl.jena.rdf.model.DoesNotReifyException;
import plugin.rtc.com.hp.hpl.jena.rdf.model.ReifiedStatement;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Statement;
import plugin.rtc.com.hp.hpl.jena.rdf.model.impl.ModelCom;
import plugin.rtc.com.hp.hpl.jena.rdf.model.impl.ReifierStd;
import plugin.rtc.com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import plugin.rtc.com.hp.hpl.jena.rdf.model.impl.StatementImpl;

public class ReifiedStatementImpl
extends ResourceImpl
implements ReifiedStatement {
    protected Statement statement;
    public static final Implementation reifiedStatementFactory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            Triple x = this.getTriple(eg, n);
            if (x == null) {
                throw new DoesNotReifyException(n);
            }
            Statement st = StatementImpl.toStatement(x, (ModelCom)eg);
            return new ReifiedStatementImpl(eg, n, st);
        }

        @Override
        public boolean canWrap(Node n, EnhGraph eg) {
            return this.getTriple(eg, n) != null;
        }

        private Triple getTriple(EnhGraph eg, Node n) {
            return ReifierStd.getTriple(eg.asGraph(), n);
        }
    };

    private ReifiedStatementImpl(ModelCom m, String uri, Statement s) {
        super(uri, m);
        this.assertStatement(s);
    }

    protected ReifiedStatementImpl(EnhGraph m, Node n, Statement s) {
        super(n, m);
        this.assertStatement(s);
    }

    private void assertStatement(Statement s) {
        this.statement = s;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public boolean isValid() {
        return ReifierStd.getTriple(this.getModel().getGraph(), this.asNode()) != null;
    }

    private ReifiedStatementImpl installInReifier() {
        ReifierStd.reifyAs(this.getModel().getGraph(), this.asNode(), this.statement.asTriple());
        return this;
    }

    public static ReifiedStatement create(Statement s) {
        return ReifiedStatementImpl.create((ModelCom)s.getModel(), (String)null, s);
    }

    public static ReifiedStatementImpl create(ModelCom m, String uri, Statement s) {
        return new ReifiedStatementImpl(m, uri, s).installInReifier();
    }

    public static ReifiedStatementImpl create(EnhGraph eg, Node n, Statement s) {
        return new ReifiedStatementImpl(eg, n, s).installInReifier();
    }

    @Override
    public String toString() {
        return super.toString() + "=>" + this.statement;
    }

    public static ReifiedStatement createExistingReifiedStatement(ModelCom model, Node n) {
        Triple t = ReifierStd.getTriple(model.getGraph(), n);
        return new ReifiedStatementImpl((EnhGraph)model, n, model.asStatement(t));
    }
}

