/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.rdf.model.impl;

import java.util.Iterator;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.graph.Triple;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Literal;
import plugin.rtc.com.hp.hpl.jena.rdf.model.NodeIterator;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Property;
import plugin.rtc.com.hp.hpl.jena.rdf.model.RDFNode;
import plugin.rtc.com.hp.hpl.jena.rdf.model.ResIterator;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Resource;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Statement;
import plugin.rtc.com.hp.hpl.jena.rdf.model.StmtIterator;
import plugin.rtc.com.hp.hpl.jena.rdf.model.impl.ModelCom;
import plugin.rtc.com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import plugin.rtc.com.hp.hpl.jena.rdf.model.impl.ResIteratorImpl;
import plugin.rtc.com.hp.hpl.jena.rdf.model.impl.StmtIteratorImpl;
import plugin.rtc.com.hp.hpl.jena.util.iterator.Map1;
import plugin.rtc.com.hp.hpl.jena.util.iterator.WrappedIterator;

public final class IteratorFactory {
    private IteratorFactory() {
    }

    public static StmtIterator asStmtIterator(Iterator<Triple> i, final ModelCom m) {
        Map1<Triple, Statement> asStatement = new Map1<Triple, Statement>(){

            @Override
            public Statement map1(Triple t) {
                return m.asStatement(t);
            }
        };
        return new StmtIteratorImpl((Iterator<Statement>)WrappedIterator.create(i).mapWith(asStatement));
    }

    public static ResIterator asResIterator(Iterator<Node> i, final ModelCom m) {
        Map1<Node, Resource> asResource = new Map1<Node, Resource>(){

            @Override
            public Resource map1(Node o) {
                return (Resource)m.asRDFNode(o);
            }
        };
        return new ResIteratorImpl(WrappedIterator.create(i).mapWith(asResource), null);
    }

    public static NodeIterator asRDFNodeIterator(Iterator<Node> i, final ModelCom m) {
        Map1<Node, RDFNode> asRDFNode = new Map1<Node, RDFNode>(){

            @Override
            public RDFNode map1(Node o) {
                return m.asRDFNode(o);
            }
        };
        return new NodeIteratorImpl(WrappedIterator.create(i).mapWith(asRDFNode), null);
    }

    static Resource asResource(Node n, ModelCom m) {
        return IteratorFactory.asResource(n, Resource.class, m);
    }

    static Property asProperty(Node n, ModelCom m) {
        return (Property)IteratorFactory.asResource(n, Property.class, m);
    }

    static Literal asLiteral(Node n, ModelCom m) {
        return m.getNodeAs(n, Literal.class);
    }

    static <X extends RDFNode> Resource asResource(Node n, Class<X> cl, ModelCom m) {
        return (Resource)m.getNodeAs(n, cl);
    }
}

