/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.mem;

import java.util.HashSet;
import java.util.Set;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.graph.Triple;
import plugin.rtc.com.hp.hpl.jena.mem.HashCommon;
import plugin.rtc.com.hp.hpl.jena.mem.TripleBunch;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.WrappedIterator;

public class SetBunch
implements TripleBunch {
    protected Set<Triple> elements = new HashSet<Triple>(20);

    public SetBunch(TripleBunch b) {
        ExtendedIterator<Triple> it = b.iterator();
        while (it.hasNext()) {
            this.elements.add((Triple)it.next());
        }
    }

    protected static boolean equalsObjectOK(Triple t) {
        Node o = t.getObject();
        return o.isLiteral() ? o.getLiteralDatatype() == null : true;
    }

    @Override
    public boolean contains(Triple t) {
        return this.elements.contains(t);
    }

    @Override
    public boolean containsBySameValueAs(Triple t) {
        return SetBunch.equalsObjectOK(t) ? this.elements.contains(t) : this.slowContains(t);
    }

    protected boolean slowContains(Triple t) {
        for (Triple element : this.elements) {
            if (!t.matches(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public void add(Triple t) {
        this.elements.add(t);
    }

    @Override
    public void remove(Triple t) {
        this.elements.remove(t);
    }

    @Override
    public ExtendedIterator<Triple> iterator(HashCommon.NotifyEmpty container) {
        return this.iterator();
    }

    @Override
    public ExtendedIterator<Triple> iterator() {
        return WrappedIterator.create(this.elements.iterator());
    }
}

