/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.graph.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import plugin.rtc.com.hp.hpl.jena.graph.BulkUpdateHandler;
import plugin.rtc.com.hp.hpl.jena.graph.Graph;
import plugin.rtc.com.hp.hpl.jena.graph.GraphEventManager;
import plugin.rtc.com.hp.hpl.jena.graph.GraphEvents;
import plugin.rtc.com.hp.hpl.jena.graph.GraphUtil;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.graph.Triple;
import plugin.rtc.com.hp.hpl.jena.graph.impl.GraphWithPerform;
import plugin.rtc.com.hp.hpl.jena.util.IteratorCollection;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class SimpleBulkUpdateHandler
implements BulkUpdateHandler {
    protected GraphWithPerform graph;
    protected GraphEventManager manager;

    public SimpleBulkUpdateHandler(GraphWithPerform graph) {
        this.graph = graph;
        this.manager = graph.getEventManager();
    }

    @Override
    @Deprecated
    public void add(Triple[] triples) {
        for (Triple triple : triples) {
            this.graph.performAdd(triple);
        }
        this.manager.notifyAddArray(this.graph, triples);
    }

    @Override
    @Deprecated
    public void add(List<Triple> triples) {
        this.add(triples, true);
    }

    protected void add(List<Triple> triples, boolean notify) {
        for (Triple triple : triples) {
            this.graph.performAdd(triple);
        }
        if (notify) {
            this.manager.notifyAddList(this.graph, triples);
        }
    }

    @Override
    @Deprecated
    public void add(Iterator<Triple> it) {
        this.addIterator(it, true);
    }

    public void addIterator(Iterator<Triple> it, boolean notify) {
        List<Triple> s = IteratorCollection.iteratorToList(it);
        this.add(s, false);
        if (notify) {
            this.manager.notifyAddIterator((Graph)this.graph, s);
        }
    }

    @Override
    @Deprecated
    public void add(Graph g) {
        this.addIterator(GraphUtil.findAll(g), false);
        this.manager.notifyAddGraph(this.graph, g);
    }

    @Override
    @Deprecated
    public void add(Graph g, boolean withReifications) {
        this.add(g);
    }

    @Override
    @Deprecated
    public void delete(Triple[] triples) {
        for (Triple triple : triples) {
            this.graph.performDelete(triple);
        }
        this.manager.notifyDeleteArray(this.graph, triples);
    }

    @Override
    @Deprecated
    public void delete(List<Triple> triples) {
        this.delete(triples, true);
    }

    protected void delete(List<Triple> triples, boolean notify) {
        for (Triple triple : triples) {
            this.graph.performDelete(triple);
        }
        if (notify) {
            this.manager.notifyDeleteList(this.graph, triples);
        }
    }

    @Override
    @Deprecated
    public void delete(Iterator<Triple> it) {
        this.deleteIterator(it, true);
    }

    public void deleteIterator(Iterator<Triple> it, boolean notify) {
        List<Triple> L = IteratorCollection.iteratorToList(it);
        this.delete(L, false);
        if (notify) {
            this.manager.notifyDeleteIterator((Graph)this.graph, L);
        }
    }

    private List<Triple> triplesOf(Graph g) {
        ArrayList<Triple> L = new ArrayList<Triple>();
        ExtendedIterator<Triple> it = g.find(Triple.ANY);
        while (it.hasNext()) {
            L.add((Triple)it.next());
        }
        return L;
    }

    @Override
    @Deprecated
    public void delete(Graph g) {
        this.delete(g, false);
    }

    @Override
    @Deprecated
    public void delete(Graph g, boolean withReifications) {
        if (g.dependsOn(this.graph)) {
            this.delete(this.triplesOf(g));
        } else {
            this.deleteIterator(GraphUtil.findAll(g), false);
        }
        this.manager.notifyDeleteGraph(this.graph, g);
    }

    @Override
    @Deprecated
    public void removeAll() {
        SimpleBulkUpdateHandler.removeAll(this.graph);
        this.notifyRemoveAll();
    }

    protected void notifyRemoveAll() {
        this.manager.notifyEvent(this.graph, GraphEvents.removeAll);
    }

    @Override
    @Deprecated
    public void remove(Node s, Node p, Node o) {
        SimpleBulkUpdateHandler.removeAll(this.graph, s, p, o);
        this.manager.notifyEvent(this.graph, GraphEvents.remove(s, p, o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll(Graph g, Node s, Node p, Node o) {
        try (ExtendedIterator<Triple> it = g.find(s, p, o);){
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll(Graph g) {
        try (ExtendedIterator<Triple> it = GraphUtil.findAll(g);){
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
    }
}

