/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.assembler.assemblers;

import java.util.ArrayList;
import java.util.List;
import plugin.rtc.com.hp.hpl.jena.assembler.Assembler;
import plugin.rtc.com.hp.hpl.jena.assembler.JA;
import plugin.rtc.com.hp.hpl.jena.assembler.Mode;
import plugin.rtc.com.hp.hpl.jena.assembler.assemblers.InfModelAssembler;
import plugin.rtc.com.hp.hpl.jena.ontology.OntModel;
import plugin.rtc.com.hp.hpl.jena.ontology.OntModelSpec;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Model;
import plugin.rtc.com.hp.hpl.jena.rdf.model.ModelFactory;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Resource;
import plugin.rtc.com.hp.hpl.jena.rdf.model.StmtIterator;

public class OntModelAssembler
extends InfModelAssembler
implements Assembler {
    private static final OntModelSpec defaultSpec = OntModelSpec.OWL_MEM_RDFS_INF;

    @Override
    public Model openEmptyModel(Assembler a, Resource root, Mode mode) {
        this.checkType(root, JA.OntModel);
        Model baseModel = this.getBase(a, root, mode);
        OntModelSpec oms = this.getOntModelSpec(a, root);
        OntModel om = ModelFactory.createOntologyModel(oms, baseModel);
        this.addSubModels(a, root, mode, om);
        return om;
    }

    private void addSubModels(Assembler a, Resource root, Mode mode, OntModel om) {
        List<Model> subModels = this.getSubModels(a, root, mode);
        for (Model subModel : subModels) {
            om.addSubModel(subModel);
        }
    }

    private List<Model> getSubModels(Assembler a, Resource root, Mode mode) {
        ArrayList<Model> result = new ArrayList<Model>();
        StmtIterator it = root.listProperties(JA.subModel);
        while (it.hasNext()) {
            result.add(a.openModel(it.nextStatement().getResource(), mode));
        }
        return result;
    }

    protected OntModelSpec getOntModelSpec(Assembler a, Resource root) {
        Resource r = OntModelAssembler.getUniqueResource(root, JA.ontModelSpec);
        return r == null ? defaultSpec : (OntModelSpec)a.open(r);
    }
}

