/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.assembler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import plugin.rtc.com.hp.hpl.jena.assembler.AssemblerHelp;
import plugin.rtc.com.hp.hpl.jena.assembler.BadObjectException;
import plugin.rtc.com.hp.hpl.jena.assembler.JA;
import plugin.rtc.com.hp.hpl.jena.graph.Graph;
import plugin.rtc.com.hp.hpl.jena.graph.compose.MultiUnion;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Model;
import plugin.rtc.com.hp.hpl.jena.rdf.model.ModelFactory;
import plugin.rtc.com.hp.hpl.jena.rdf.model.RDFNode;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Resource;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Statement;
import plugin.rtc.com.hp.hpl.jena.rdf.model.StmtIterator;
import plugin.rtc.com.hp.hpl.jena.util.FileManager;
import plugin.rtc.com.hp.hpl.jena.vocabulary.OWL;

public class ImportManager {
    public static final ImportManager instance = new ImportManager();
    protected Map<String, Graph> cache = new HashMap<String, Graph>();

    public void clear() {
        this.cache.clear();
    }

    public Model withImports(Model model) {
        return this.withImports(FileManager.get(), model);
    }

    public Model withImports(FileManager fm, Model model) {
        return this.withImports(fm, model, new HashSet<String>());
    }

    private Model withImports(FileManager fm, Model model, Set<String> loading) {
        StmtIterator oit = model.listStatements(null, OWL.imports, (RDFNode)null);
        StmtIterator jit = model.listStatements(null, JA.imports, (RDFNode)null);
        if (oit.hasNext() || jit.hasNext()) {
            MultiUnion g = new MultiUnion(new Graph[]{model.getGraph()});
            this.addImportedGraphs(fm, loading, oit, g);
            this.addImportedGraphs(fm, loading, jit, g);
            return ModelFactory.createModelForGraph(g);
        }
        return model;
    }

    private void addImportedGraphs(FileManager fm, Set<String> loading, StmtIterator oit, MultiUnion g) {
        while (oit.hasNext()) {
            String path = this.getObjectURI(oit.nextStatement());
            if (!loading.add(path)) continue;
            g.addGraph(this.graphFor(fm, loading, path));
        }
    }

    private String getObjectURI(Statement s) {
        RDFNode ob = s.getObject();
        if (ob.isLiteral()) {
            return AssemblerHelp.getString(s);
        }
        if (ob.isAnon()) {
            throw new BadObjectException(s);
        }
        return ((Resource)ob).getURI();
    }

    protected Graph graphFor(FileManager fm, Set<String> loading, String path) {
        Graph already = this.cache.get(path);
        if (already == null) {
            Graph result = this.withImports(fm, fm.loadModel(path), loading).getGraph();
            this.cache.put(path, result);
            return result;
        }
        return already;
    }
}

