/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.rtc.licensevalidator.service.helper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.bugtracker.rtc.licensevalidator.com.license4j.License;
import org.squashtest.tm.plugin.bugtracker.rtc.licensevalidator.com.license4j.exceptions.LicenseSecurityException;

public class ValidationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationHelper.class);
    public static final ValidationHelper INSTANCE = new ValidationHelper();
    private static final String MAX_USERS = "max-users";

    private ValidationHelper() {
    }

    public int getMaxAllowedUsersInLicense(License license) {
        String max = license.getLicenseText().getCustomSignedFeature(MAX_USERS);
        if (max == null) {
            LOGGER.warn("Number of authorized users is not indicated in your license file, please contact support.");
            return 0;
        }
        return Integer.parseInt(max);
    }

    public void isCurrentPluginAllowed(License license, String plugin, Boolean logAllowed) throws LicenseSecurityException {
        String isAllowed;
        if (logAllowed.booleanValue()) {
            LOGGER.debug("check if license valid for {} ...", (Object)plugin);
        }
        if ((isAllowed = license.getLicenseText().getCustomSignedFeature(plugin)) == null) {
            LOGGER.warn("{} is not indicated in your license file, please contact support.", (Object)plugin);
            isAllowed = "false";
        }
        if (!Boolean.valueOf(isAllowed).booleanValue()) {
            throw new LicenseSecurityException("Current license does not grant access to this plugin: " + plugin);
        }
    }
}

