/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.org.apache.http.nio.protocol;

import java.io.IOException;
import jiracloud.org.apache.http.ContentTooLongException;
import jiracloud.org.apache.http.HttpEntity;
import jiracloud.org.apache.http.HttpResponse;
import jiracloud.org.apache.http.entity.ContentType;
import jiracloud.org.apache.http.nio.ContentDecoder;
import jiracloud.org.apache.http.nio.IOControl;
import jiracloud.org.apache.http.nio.entity.ContentBufferEntity;
import jiracloud.org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import jiracloud.org.apache.http.nio.util.HeapByteBufferAllocator;
import jiracloud.org.apache.http.nio.util.SimpleInputBuffer;
import jiracloud.org.apache.http.protocol.HttpContext;
import jiracloud.org.apache.http.util.Asserts;

public class BasicAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private static final int MAX_INITIAL_BUFFER_SIZE = 262144;
    private volatile HttpResponse response;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onResponseReceived(HttpResponse response) throws IOException {
        this.response = response;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: %,d", len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        int initialBufferSize = Math.min((int)len, 262144);
        this.buf = new SimpleInputBuffer(initialBufferSize, new HeapByteBufferAllocator());
        this.response.setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioControl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.response = null;
        this.buf = null;
    }

    @Override
    protected HttpResponse buildResult(HttpContext context) {
        return this.response;
    }
}

