/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.jira.rest.client.internal.async;

import java.io.IOException;
import java.net.URI;
import jiracloud.com.atlassian.jira.rest.client.api.AuditRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.ComponentRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.GroupRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.IssueRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.JiraRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.MetadataRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.MyPermissionsRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.ProjectRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.ProjectRolesRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.SearchRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.SessionRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.UserRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.VersionRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousAuditRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousComponentRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousGroupRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousIssueRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousMetadataRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousMyPermissionsRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousProjectRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousProjectRolesRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousSearchRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousSessionRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousUserRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousVersionRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import jiracloud.com.sun.ws.rs.core.UriBuilder;

public class AsynchronousJiraRestClient
implements JiraRestClient {
    private final IssueRestClient issueRestClient;
    private final SessionRestClient sessionRestClient;
    private final UserRestClient userRestClient;
    private final GroupRestClient groupRestClient;
    private final ProjectRestClient projectRestClient;
    private final ComponentRestClient componentRestClient;
    private final MetadataRestClient metadataRestClient;
    private final SearchRestClient searchRestClient;
    private final VersionRestClient versionRestClient;
    private final ProjectRolesRestClient projectRolesRestClient;
    private final MyPermissionsRestClient myPermissionsRestClient;
    private final DisposableHttpClient httpClient;
    private final AuditRestClient auditRestClient;

    public AsynchronousJiraRestClient(URI serverUri, DisposableHttpClient httpClient) {
        URI baseUri = UriBuilder.fromUri(serverUri).path("/rest/api/latest").build(new Object[0]);
        this.httpClient = httpClient;
        this.metadataRestClient = new AsynchronousMetadataRestClient(baseUri, httpClient);
        this.sessionRestClient = new AsynchronousSessionRestClient(serverUri, httpClient);
        this.issueRestClient = new AsynchronousIssueRestClient(baseUri, httpClient, this.sessionRestClient, this.metadataRestClient);
        this.userRestClient = new AsynchronousUserRestClient(baseUri, httpClient);
        this.groupRestClient = new AsynchronousGroupRestClient(baseUri, httpClient);
        this.projectRestClient = new AsynchronousProjectRestClient(baseUri, httpClient);
        this.componentRestClient = new AsynchronousComponentRestClient(baseUri, httpClient);
        this.searchRestClient = new AsynchronousSearchRestClient(baseUri, httpClient);
        this.versionRestClient = new AsynchronousVersionRestClient(baseUri, httpClient);
        this.projectRolesRestClient = new AsynchronousProjectRolesRestClient(serverUri, httpClient);
        this.myPermissionsRestClient = new AsynchronousMyPermissionsRestClient(baseUri, httpClient);
        this.auditRestClient = new AsynchronousAuditRestClient(httpClient, baseUri);
    }

    @Override
    public IssueRestClient getIssueClient() {
        return this.issueRestClient;
    }

    @Override
    public SessionRestClient getSessionClient() {
        return this.sessionRestClient;
    }

    @Override
    public UserRestClient getUserClient() {
        return this.userRestClient;
    }

    @Override
    public GroupRestClient getGroupClient() {
        return this.groupRestClient;
    }

    @Override
    public ProjectRestClient getProjectClient() {
        return this.projectRestClient;
    }

    @Override
    public ComponentRestClient getComponentClient() {
        return this.componentRestClient;
    }

    @Override
    public MetadataRestClient getMetadataClient() {
        return this.metadataRestClient;
    }

    @Override
    public SearchRestClient getSearchClient() {
        return this.searchRestClient;
    }

    @Override
    public VersionRestClient getVersionRestClient() {
        return this.versionRestClient;
    }

    @Override
    public ProjectRolesRestClient getProjectRolesRestClient() {
        return this.projectRolesRestClient;
    }

    @Override
    public MyPermissionsRestClient getMyPermissionsRestClient() {
        return this.myPermissionsRestClient;
    }

    @Override
    public AuditRestClient getAuditRestClient() {
        return this.auditRestClient;
    }

    @Override
    public void close() throws IOException {
        try {
            this.httpClient.destroy();
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
    }
}

