/*
 * Decompiled with CFR 0.152.
 */
package bugzilla.org.apache.xmlrpc.util;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private long available;
    private long markedAvailable;
    private InputStream in;

    public LimitedInputStream(InputStream pIn, int pAvailable) {
        this.in = pIn;
        this.available = pAvailable;
    }

    public int read() throws IOException {
        if (this.available > 0L) {
            --this.available;
            return this.in.read();
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.available > 0L) {
            int read;
            if ((long)len > this.available) {
                len = (int)this.available;
            }
            this.available = (read = this.in.read(b, off, len)) == -1 ? 0L : (this.available -= (long)read);
            return read;
        }
        return -1;
    }

    public long skip(long n) throws IOException {
        long skip = this.in.skip(n);
        if (this.available > 0L) {
            this.available -= skip;
        }
        return skip;
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markedAvailable = this.available;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.available = this.markedAvailable;
    }

    public boolean markSupported() {
        return true;
    }
}

