/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.com.apollographql.apollo.internal;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import xsquash4gitlab.com.apollographql.apollo.ApolloCall;
import xsquash4gitlab.com.apollographql.apollo.ApolloQueryWatcher;
import xsquash4gitlab.com.apollographql.apollo.api.Operation;
import xsquash4gitlab.com.apollographql.apollo.api.Response;
import xsquash4gitlab.com.apollographql.apollo.api.internal.ApolloLogger;
import xsquash4gitlab.com.apollographql.apollo.api.internal.Optional;
import xsquash4gitlab.com.apollographql.apollo.api.internal.Utils;
import xsquash4gitlab.com.apollographql.apollo.cache.normalized.ApolloStore;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloCanceledException;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloException;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloHttpException;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloNetworkException;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloParseException;
import xsquash4gitlab.com.apollographql.apollo.fetcher.ResponseFetcher;
import xsquash4gitlab.com.apollographql.apollo.internal.ApolloCallTracker;
import xsquash4gitlab.com.apollographql.apollo.internal.CallState;
import xsquash4gitlab.com.apollographql.apollo.internal.RealApolloCall;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;
import xsquash4gitlab.org.jetbrains.annotations.Nullable;

final class RealApolloQueryWatcher<T>
implements ApolloQueryWatcher<T> {
    private RealApolloCall<T> activeCall;
    private ResponseFetcher refetchResponseFetcher;
    final ApolloStore apolloStore;
    Set<String> dependentKeys = Collections.emptySet();
    final ApolloLogger logger;
    private final ApolloCallTracker tracker;
    final ApolloStore.RecordChangeSubscriber recordChangeSubscriber = new ApolloStore.RecordChangeSubscriber(){

        @Override
        public void onCacheRecordsChanged(Set<String> changedRecordKeys) {
            if (RealApolloQueryWatcher.this.dependentKeys.isEmpty() || !RealApolloQueryWatcher.areDisjoint(RealApolloQueryWatcher.this.dependentKeys, changedRecordKeys)) {
                RealApolloQueryWatcher.this.refetch();
            }
        }
    };
    private final AtomicReference<CallState> state = new AtomicReference<CallState>(CallState.IDLE);
    private final AtomicReference<ApolloCall.Callback<T>> originalCallback = new AtomicReference();

    RealApolloQueryWatcher(RealApolloCall<T> originalCall, ApolloStore apolloStore, ApolloLogger logger, ApolloCallTracker tracker, ResponseFetcher refetchResponseFetcher) {
        this.activeCall = originalCall;
        this.apolloStore = apolloStore;
        this.logger = logger;
        this.tracker = tracker;
        this.refetchResponseFetcher = refetchResponseFetcher;
    }

    @Override
    public ApolloQueryWatcher<T> enqueueAndWatch(@Nullable ApolloCall.Callback<T> callback) {
        try {
            this.activate(Optional.fromNullable(callback));
        }
        catch (ApolloCanceledException e) {
            if (callback != null) {
                callback.onCanceledError(e);
            } else {
                this.logger.e(e, "Operation: %s was canceled", this.operation().name().name());
            }
            return this;
        }
        this.activeCall.enqueue(this.callbackProxy());
        return this;
    }

    @Override
    @NotNull
    public synchronized RealApolloQueryWatcher<T> refetchResponseFetcher(@NotNull ResponseFetcher fetcher) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        Utils.checkNotNull(fetcher, "responseFetcher == null");
        this.refetchResponseFetcher = fetcher;
        return this;
    }

    @Override
    public synchronized void cancel() {
        switch (this.state.get()) {
            case ACTIVE: {
                try {
                    this.activeCall.cancel();
                    this.apolloStore.unsubscribe(this.recordChangeSubscriber);
                    break;
                }
                finally {
                    this.tracker.unregisterQueryWatcher(this);
                    this.originalCallback.set(null);
                    this.state.set(CallState.CANCELED);
                }
            }
            case IDLE: {
                this.state.set(CallState.CANCELED);
                break;
            }
            case CANCELED: 
            case TERMINATED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    @Override
    @NotNull
    public Operation operation() {
        return this.activeCall.operation();
    }

    @Override
    public synchronized void refetch() {
        switch (this.state.get()) {
            case ACTIVE: {
                this.apolloStore.unsubscribe(this.recordChangeSubscriber);
                this.activeCall.cancel();
                this.activeCall = ((RealApolloCall)this.activeCall.clone()).responseFetcher(this.refetchResponseFetcher);
                this.activeCall.enqueue(this.callbackProxy());
                break;
            }
            case IDLE: {
                throw new IllegalStateException("Cannot refetch a watcher which has not first called enqueueAndWatch.");
            }
            case CANCELED: {
                throw new IllegalStateException("Cannot refetch a canceled watcher,");
            }
            case TERMINATED: {
                throw new IllegalStateException("Cannot refetch a watcher which has experienced an error.");
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    @Override
    @NotNull
    public ApolloQueryWatcher<T> clone() {
        return new RealApolloQueryWatcher<T>(this.activeCall.clone(), this.apolloStore, this.logger, this.tracker, this.refetchResponseFetcher);
    }

    private ApolloCall.Callback<T> callbackProxy() {
        return new ApolloCall.Callback<T>(){

            @Override
            public void onResponse(@NotNull Response<T> response) {
                Optional callback = RealApolloQueryWatcher.this.responseCallback();
                if (!callback.isPresent()) {
                    RealApolloQueryWatcher.this.logger.d("onResponse for watched operation: %s. No callback present.", RealApolloQueryWatcher.this.operation().name().name());
                    return;
                }
                RealApolloQueryWatcher.this.dependentKeys = response.getDependentKeys();
                RealApolloQueryWatcher.this.apolloStore.subscribe(RealApolloQueryWatcher.this.recordChangeSubscriber);
                callback.get().onResponse(response);
            }

            @Override
            public void onFailure(@NotNull ApolloException e) {
                Optional callback = RealApolloQueryWatcher.this.terminate();
                if (!callback.isPresent()) {
                    RealApolloQueryWatcher.this.logger.d(e, "onFailure for operation: %s. No callback present.", RealApolloQueryWatcher.this.operation().name().name());
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    callback.get().onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloParseException) {
                    callback.get().onParseError((ApolloParseException)e);
                } else if (e instanceof ApolloNetworkException) {
                    callback.get().onNetworkError((ApolloNetworkException)e);
                } else {
                    callback.get().onFailure(e);
                }
            }

            @Override
            public void onStatusEvent(@NotNull ApolloCall.StatusEvent event) {
                ApolloCall.Callback callback = (ApolloCall.Callback)RealApolloQueryWatcher.this.originalCallback.get();
                if (callback == null) {
                    RealApolloQueryWatcher.this.logger.d("onStatusEvent for operation: %s. No callback present.", RealApolloQueryWatcher.this.operation().name().name());
                    return;
                }
                callback.onStatusEvent(event);
            }
        };
    }

    private synchronized void activate(Optional<ApolloCall.Callback<T>> callback) throws ApolloCanceledException {
        switch (this.state.get()) {
            case IDLE: {
                this.originalCallback.set(callback.orNull());
                this.tracker.registerQueryWatcher(this);
                break;
            }
            case CANCELED: {
                throw new ApolloCanceledException();
            }
            case ACTIVE: 
            case TERMINATED: {
                throw new IllegalStateException("Already Executed");
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
        this.state.set(CallState.ACTIVE);
    }

    synchronized Optional<ApolloCall.Callback<T>> responseCallback() {
        switch (this.state.get()) {
            case ACTIVE: 
            case CANCELED: {
                return Optional.fromNullable(this.originalCallback.get());
            }
            case IDLE: 
            case TERMINATED: {
                throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    synchronized Optional<ApolloCall.Callback<T>> terminate() {
        switch (this.state.get()) {
            case ACTIVE: {
                this.tracker.unregisterQueryWatcher(this);
                this.state.set(CallState.TERMINATED);
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case CANCELED: {
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case IDLE: 
            case TERMINATED: {
                throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    private static <E> boolean areDisjoint(Set<E> setOne, Set<E> setTwo) {
        if (setOne == null || setTwo == null) {
            return true;
        }
        Set<E> smallerSet = setOne;
        Set<E> largerSet = setTwo;
        if (setOne.size() > setTwo.size()) {
            smallerSet = setTwo;
            largerSet = setOne;
        }
        for (E el : smallerSet) {
            if (!largerSet.contains(el)) continue;
            return false;
        }
        return true;
    }
}

