/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.BaseBatchProcessingOrchestrator;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.NoteProcessInfo;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.update.AbstractIssueNoteBatchUpdater;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.update.IssueNoteBatchUpdaterRegistry;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;

public class IssueNoteBatchUpdateOrchestrator
extends BaseBatchProcessingOrchestrator<AbstractIssueNoteBatchUpdater> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueNoteBatchUpdateOrchestrator.class);

    public IssueNoteBatchUpdateOrchestrator() {
        super(IssueNoteBatchUpdaterRegistry.BATCH_UPDATERS);
    }

    public BatchUpdateResult updateNotes(GitLabClient client, List<NoteProcessInfo> notesToUpdate) {
        HashMap<String, List<String>> allErrors = new HashMap<String, List<String>>();
        HashMap<String, String> allSuccess = new HashMap<String, String>();
        this.processBatches(notesToUpdate, (processingUnit, batch) -> {
            Date startTime = new Date();
            LOGGER.debug("Processing {} notes to update", (Object)batch.size());
            Map<String, String> processedWithSuccess = batch.stream().collect(Collectors.toMap(NoteProcessInfo::getIssueGlobalId, note -> note.existingNoteGlobalId));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("About to process batch with: {}", (Object)batch.stream().limit(5L).map(NoteProcessInfo::prettyPrint).collect(Collectors.joining(", ")));
            }
            Map<String, List<String>> errorsByIssueId = processingUnit.processBatch(client, batch);
            for (String errorIssueId : errorsByIssueId.keySet()) {
                processedWithSuccess.remove(errorIssueId);
            }
            allErrors.putAll(errorsByIssueId);
            allSuccess.putAll(processedWithSuccess);
            if (errorsByIssueId.values().stream().anyMatch(value -> !value.isEmpty())) {
                LOGGER.error("Encountered errors while updating GitLab note batches:\n{}", (Object)IssueNoteBatchUpdateOrchestrator.prettyPrintErrors(errorsByIssueId));
            }
            LOGGER.debug("Processed {} notes in {} ms", (Object)batch.size(), (Object)(new Date().getTime() - startTime.getTime()));
        });
        return new BatchUpdateResult(allErrors, allSuccess);
    }

    @NotNull
    private static String prettyPrintErrors(Map<String, List<String>> errorsByIssueId) {
        int totalErrors = errorsByIssueId.values().stream().mapToInt(List::size).sum();
        Stream<String> formattedErrors = errorsByIssueId.entrySet().stream().map(entry -> ((List)entry.getValue()).stream().map(error -> "[%s] %s".formatted(entry.getKey(), error)).toList()).flatMap(Collection::stream).limit(5L);
        if (totalErrors > 5) {
            formattedErrors = Stream.concat(formattedErrors, Stream.of("... and %d more errors".formatted(totalErrors - 5)));
        }
        return formattedErrors.collect(Collectors.joining("\n"));
    }

    public static final class BatchUpdateResult {
        private final Map<String, List<String>> errorsByIssueId;
        private final Map<String, String> successfullyUpdatedNoteIdByIssueId;
        private final List<String> fallbackToCreateIssueIds = new ArrayList<String>();

        public BatchUpdateResult(Map<String, List<String>> errorsByIssueId, Map<String, String> successfullyUpdatedNoteIdByIssueId) {
            this.errorsByIssueId = errorsByIssueId;
            this.successfullyUpdatedNoteIdByIssueId = successfullyUpdatedNoteIdByIssueId;
        }

        public Map<String, List<String>> getErrorsByIssueId() {
            return this.errorsByIssueId;
        }

        public void addFallbackToCreate(String issueId) {
            this.fallbackToCreateIssueIds.add(issueId);
        }

        public List<String> getFallbackToCreateIssueIds() {
            return this.fallbackToCreateIssueIds;
        }

        public String getSuccessfullyUpdatedNoteId(String issueId) {
            return this.successfullyUpdatedNoteIdByIssueId.get(issueId);
        }
    }
}

