/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import com.google.common.collect.Sets;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabIssueType;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabNamedReferenceDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabPerimeterInfoDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabUserDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.IterationDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.MilestoneDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.model.Mappings;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabInstanceType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSelectType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.PerimeterType;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.GitLabPerimeterRequestException;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.GraphqlClientException;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.InvalidGitLabPerimeterException;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.MaxItemPerSyncException;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.NoCredentialsException;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClientProvider;

@Service
@Transactional(readOnly=true)
public class GitLabPerimeterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabPerimeterService.class);
    private final GitLabClientProvider gitLabClientProvider;
    private final Environment environment;
    @PersistenceContext
    EntityManager em;

    public GitLabPerimeterService(GitLabClientProvider gitLabClientProvider, Environment environment) {
        this.gitLabClientProvider = gitLabClientProvider;
        this.environment = environment;
    }

    public PerimeterType getPerimeterType(GitLabClient client, String perimeter) throws InvalidGitLabPerimeterException {
        Optional<String> id = client.getProjectClient().getId(perimeter);
        if (id.isPresent()) {
            return PerimeterType.PROJECT;
        }
        return this.checkIfPerimeterIsGroup(client, perimeter);
    }

    public GitLabInstanceType getGitLabInstanceType(GitLabClient client, PerimeterType perimeterType) throws InvalidGitLabPerimeterException {
        boolean isEnterpriseEdition = PerimeterType.PROJECT.equals((Object)perimeterType) ? client.getProjectClient().isInstanceEnterpriseEdition() : client.getGroupClient().isInstanceEnterpriseEdition();
        return isEnterpriseEdition ? GitLabInstanceType.PREMIUM : GitLabInstanceType.COMMUNITY;
    }

    private PerimeterType checkIfPerimeterIsGroup(GitLabClient client, String perimeter) throws InvalidGitLabPerimeterException {
        Optional<String> id = client.getGroupClient().getId(perimeter);
        if (id.isPresent()) {
            return PerimeterType.GROUP;
        }
        throw new InvalidGitLabPerimeterException(perimeter);
    }

    public GitLabPerimeterInfoDto getPerimeterReferentialData(Long bugtrackerId, String perimeter) throws InvalidGitLabPerimeterException {
        GitLabClient client = this.gitLabClientProvider.getGitLabClient(bugtrackerId);
        GitLabPerimeterInfoDto dto = new GitLabPerimeterInfoDto();
        try {
            PerimeterType perimeterType = this.getPerimeterType(client, perimeter);
            GitLabInstanceType gitLabInstanceType = this.getGitLabInstanceType(client, perimeterType);
            dto.setUsers(this.getUserDtos(client, perimeter, perimeterType));
            this.appendLabels(dto, client, perimeter, perimeterType);
            dto.setMilestones(this.getMilestoneDtos(client, perimeter, perimeterType));
            dto.setBoards(this.getBoardsDtos(client, perimeter, perimeterType));
            dto.setCommunityInstance(GitLabInstanceType.COMMUNITY.equals((Object)gitLabInstanceType));
            dto.setIssueTypes(GitLabIssueType.getCommunityIssueType());
            if (GitLabInstanceType.PREMIUM.equals((Object)gitLabInstanceType)) {
                dto.setEpics(this.getEpicDtos(client, perimeter, perimeterType));
                dto.setIterations(this.getIterationDtos(client, perimeter, perimeterType));
                dto.setIssueTypes(GitLabIssueType.getPremiumIssueType());
            }
        }
        catch (GraphqlClientException ex) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("The request to retrieve perimeter info failed for perimeter '%s' and server %d", perimeter, bugtrackerId), (Throwable)((Object)ex));
            }
            throw new GitLabPerimeterRequestException(bugtrackerId.toString());
        }
        return dto;
    }

    private void appendLabels(GitLabPerimeterInfoDto dto, GitLabClient client, String perimeter, PerimeterType perimeterType) {
        List<String> labels = this.getLabelDtos(client, perimeter, perimeterType);
        if (labels != null) {
            dto.setLabels(Sets.newTreeSet(labels));
        } else {
            dto.setLabels(new HashSet<String>());
        }
        dto.setDetailedLabels(Mappings.Labels.createLabelsFromList(labels));
    }

    public List<GitLabNamedReferenceDto> getBoards(Long bugtrackerId, String perimeter) {
        try {
            GitLabClient client = this.gitLabClientProvider.getGitLabClient(bugtrackerId);
            PerimeterType perimeterType = this.getPerimeterType(client, perimeter);
            return this.sortedNamedReference(this.getBoardsDtos(client, perimeter, perimeterType));
        }
        catch (GraphqlClientException | InvalidGitLabPerimeterException | NoCredentialsException ex) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("Could not fetch boards for invalid perimeter '%s' and server %d", perimeter, bugtrackerId), (Throwable)ex);
            }
            return Collections.emptyList();
        }
    }

    private List<GitLabUserDto> getUserDtos(GitLabClient client, String perimeter, PerimeterType perimeterType) {
        if (this.isProjectPerimeter(perimeterType)) {
            return client.getProjectClient().getMembers(perimeter);
        }
        return client.getGroupClient().getMembers(perimeter);
    }

    private List<String> getLabelDtos(GitLabClient client, String perimeter, PerimeterType perimeterType) {
        if (this.isProjectPerimeter(perimeterType)) {
            return client.getProjectClient().getLabels(perimeter);
        }
        return client.getGroupClient().getLabels(perimeter);
    }

    public List<MilestoneDto> getMilestoneDtos(GitLabClient client, String perimeter, PerimeterType perimeterType) {
        if (this.isProjectPerimeter(perimeterType)) {
            return this.sortedMilestones(client.getProjectClient().getMilestones(perimeter));
        }
        return this.sortedMilestones(client.getGroupClient().getMilestones(perimeter));
    }

    private List<GitLabNamedReferenceDto> getEpicDtos(GitLabClient client, String perimeter, PerimeterType perimeterType) {
        if (this.isProjectPerimeter(perimeterType)) {
            return this.sortedNamedReference(client.getProjectClient().getEpics(perimeter));
        }
        return this.sortedNamedReference(client.getGroupClient().getEpics(perimeter));
    }

    public List<IterationDto> getIterationDtos(GitLabClient client, String perimeter, PerimeterType perimeterType) {
        if (this.isProjectPerimeter(perimeterType)) {
            return client.getProjectClient().getIterations(perimeter);
        }
        return client.getGroupClient().getIterations(perimeter);
    }

    private List<GitLabNamedReferenceDto> getBoardsDtos(GitLabClient client, String perimeter, PerimeterType perimeterType) {
        if (this.isProjectPerimeter(perimeterType)) {
            return this.sortedNamedReference(client.getProjectClient().getBoards(perimeter));
        }
        return this.sortedNamedReference(client.getGroupClient().getBoards(perimeter));
    }

    private List<GitLabNamedReferenceDto> sortedNamedReference(List<GitLabNamedReferenceDto> namedReferences) {
        return Optional.ofNullable(namedReferences).map(refs -> refs.stream().sorted(Comparator.comparing(GitLabNamedReferenceDto::getTitle)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private List<MilestoneDto> sortedMilestones(List<MilestoneDto> namedReferences) {
        return Optional.ofNullable(namedReferences).map(refs -> refs.stream().sorted(Comparator.comparing(MilestoneDto::getTitle)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private boolean isProjectPerimeter(PerimeterType perimeterType) {
        return PerimeterType.PROJECT.equals((Object)perimeterType);
    }

    public void checkIfMaxNumberOfIssuesInPerimeterExceeded(GitLabRemoteSynchronisation synchronisation, boolean syncForSprints) {
        BugTracker bugTracker;
        GitLabClient client;
        PerimeterType perimeterType;
        int nbIssues;
        Integer maxItemPerSync = this.getMaxItemPerSync();
        if (Objects.nonNull(maxItemPerSync) && (nbIssues = (perimeterType = this.getPerimeterType(client = this.gitLabClientProvider.getGitLabClient((bugTracker = synchronisation.getRemoteSynchronisation().getServer()).getId()), synchronisation.getPerimeter())).equals((Object)PerimeterType.PROJECT) ? this.getProjectIssueCount(synchronisation, client, syncForSprints) : this.getGroupIssueCount(synchronisation, client, syncForSprints)) > maxItemPerSync) {
            LOGGER.error("Too many gitlab issues in synchronisation scope: {} issues. Max number allowed: {}", (Object)nbIssues, (Object)maxItemPerSync);
            throw new MaxItemPerSyncException(nbIssues, maxItemPerSync);
        }
    }

    private Integer getMaxItemPerSync() {
        String property = this.environment.getProperty("squash.external.synchronisation.max-items-per-sync");
        Integer maxItemPerSync = null;
        if (StringUtils.isNotBlank((CharSequence)property)) {
            try {
                maxItemPerSync = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.warn("Impossible to parse the property 'squash.external.synchronisation.max-items-per-sync' as a number. Please provide a valid value.");
            }
        }
        return maxItemPerSync;
    }

    private int getProjectIssueCount(GitLabRemoteSynchronisation synchronisation, GitLabClient client, boolean syncForSprints) {
        boolean selectByBoard = syncForSprints ? GitLabRemoteSynchronisation.getSprintSelectType(synchronisation.getRemoteSynchronisation()).equals(GitLabRemoteSelectType.BOARD.name()) : synchronisation.getRemoteSynchronisation().getSelectType().equals(GitLabRemoteSelectType.BOARD.name());
        if (selectByBoard) {
            return client.getProjectClient().getBoardIssueCount(synchronisation, syncForSprints);
        }
        return client.getProjectClient().getProjectIssueCount(synchronisation, syncForSprints);
    }

    private int getGroupIssueCount(GitLabRemoteSynchronisation synchronisation, GitLabClient client, boolean syncForSprints) {
        boolean selectByBoard = syncForSprints ? GitLabRemoteSynchronisation.getSprintSelectType(synchronisation.getRemoteSynchronisation()).equals(GitLabRemoteSelectType.BOARD.name()) : synchronisation.getRemoteSynchronisation().getSelectType().equals(GitLabRemoteSelectType.BOARD.name());
        if (selectByBoard) {
            return client.getGroupClient().getBoardIssueCount(synchronisation, syncForSprints);
        }
        return client.getGroupClient().getGroupIssueCount(synchronisation, syncForSprints);
    }
}

