/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.graphql.client;

import java.util.List;
import java.util.Optional;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.FilteredBoardIssuesQueryBuilderAdapterCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.FilteredBoardIssuesQueryBuilderAdapterPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.IssuesQueryBuilderAdapterCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.IssuesQueryBuilderAdapterPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.PagingAdapter;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabNamedReferenceDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabUserDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.IterationDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.MilestoneDto;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabBoardConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabBoardScopeConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabConverters;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabEpicConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabIssueConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabIssueCountConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabIterationConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabLabelConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabMemberConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabMilestoneConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabBoardScope;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabInstanceType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.PerimeterType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValue;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.AbstractGitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.IssueFetchResult;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.GitLabIssueQueryFilterBuildersCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.GitLabIssueQueryFilterBuildersPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectBoardScopeQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectBoardsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectEpicsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectFilteredBoardIssueCountCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectFilteredBoardIssueCountQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectFilteredBoardIssuesCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectFilteredBoardIssuesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectIdQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectIssueCountCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectIssueCountQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectIssuesCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectIssuesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectIterationsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectLabelsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectMembersQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectMilestonesQuery;

public class GitLabProjectClient
extends AbstractGitLabClient {
    public GitLabProjectClient(GitLabClient gitLabClient) {
        super(gitLabClient);
    }

    public Optional<String> getId(String perimeter) {
        GetProjectIdQuery query = GetProjectIdQuery.builder().fullPath(perimeter).build();
        return this.gitLabClient.executeAndConvert(query, (data, topLevelErrors) -> GitLabConverters.extractProjectId(data));
    }

    public List<GitLabUserDto> getMembers(String perimeter) {
        GetProjectMembersQuery.Builder queryBuilder = GetProjectMembersQuery.builder();
        queryBuilder.fullPath(perimeter);
        PagingAdapter.GetProjectMembersPagingAdapter pagingAdapter = new PagingAdapter.GetProjectMembersPagingAdapter(queryBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (projectMembersData, topLevelErrors) -> GitLabMemberConverter.convertProjectGitLabUsers(projectMembersData)));
    }

    public List<String> getLabels(String perimeter) {
        GetProjectLabelsQuery.Builder queryBuilder = GetProjectLabelsQuery.builder().fullPath(perimeter);
        PagingAdapter.GetProjectLabelPagingAdapter pagingAdapter = new PagingAdapter.GetProjectLabelPagingAdapter(queryBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (projectLabelsData, topLevelErrors) -> GitLabLabelConverter.convertProjectLabels(projectLabelsData)));
    }

    public List<MilestoneDto> getMilestones(String perimeter) {
        GetProjectMilestonesQuery.Builder queryBuilder = GetProjectMilestonesQuery.builder().fullPath(perimeter);
        PagingAdapter.GetProjectMilestonesPagingAdapter pagingAdapter = new PagingAdapter.GetProjectMilestonesPagingAdapter(queryBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (projectMilestonesData, topLevelErrors) -> GitLabMilestoneConverter.convertProjectMilestones(projectMilestonesData)));
    }

    public List<GitLabNamedReferenceDto> getEpics(String perimeter) {
        GetProjectEpicsQuery.Builder queryBuilder = GetProjectEpicsQuery.builder().fullPath(perimeter);
        PagingAdapter.GetProjectEpicsPagingAdapter pagingAdapter = new PagingAdapter.GetProjectEpicsPagingAdapter(queryBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (projectEpicsData, topLevelErrors) -> GitLabEpicConverter.convertProjectEpics(projectEpicsData)));
    }

    public List<IterationDto> getIterations(String perimeter) {
        GetProjectIterationsQuery.Builder queryBuilder = GetProjectIterationsQuery.builder().fullPath(perimeter);
        PagingAdapter.GetProjectIterationsPagingAdapter pagingAdapter = new PagingAdapter.GetProjectIterationsPagingAdapter(queryBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (projectIterationsData, topLevelErrors) -> GitLabIterationConverter.convertProjectIterations(projectIterationsData)));
    }

    public List<GitLabNamedReferenceDto> getBoards(String perimeter) {
        GetProjectBoardsQuery.Builder queryBuilder = GetProjectBoardsQuery.builder().fullPath(perimeter);
        PagingAdapter.GetProjectBoardsPagingAdapter pagingAdapter = new PagingAdapter.GetProjectBoardsPagingAdapter(queryBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (data, topLevelErrors) -> GitLabBoardConverter.convertProjectBoards(data)));
    }

    public IssueFetchResult getProjectIssues(GitLabRemoteSynchronisation synchronisation) {
        return this.getProjectIssues(synchronisation, false);
    }

    public IssueFetchResult getProjectIssues(GitLabRemoteSynchronisation synchronisation, Boolean syncForSprint) {
        String perimeter = synchronisation.getPerimeter();
        GitLabInstanceType instanceType = this.getInstanceType();
        List<SynchronisationFilterValue> filterValues = syncForSprint != false ? GitLabRemoteSynchronisation.getSprintFilterValues(synchronisation.getRemoteSynchronisation()) : synchronisation.getFilterValues();
        if (GitLabInstanceType.PREMIUM.equals((Object)instanceType)) {
            IssuesQueryBuilderAdapterPremium.ProjectBuilderAdapterPremium builderAdapter = new IssuesQueryBuilderAdapterPremium.ProjectBuilderAdapterPremium();
            builderAdapter.fullPath(perimeter);
            GitLabIssueQueryFilterBuildersPremium.appendFilters(builderAdapter, filterValues);
            GetProjectIssuesQuery.Builder queryBuilder = builderAdapter.getBuilder();
            return new IssueFetchResult(PerimeterType.PROJECT, instanceType, this.fetchAllProjectIssuesPremium(queryBuilder));
        }
        IssuesQueryBuilderAdapterCommunity.ProjectBuilderAdapterCommunity builderAdapter = new IssuesQueryBuilderAdapterCommunity.ProjectBuilderAdapterCommunity();
        builderAdapter.fullPath(perimeter);
        GitLabIssueQueryFilterBuildersCommunity.appendFilters(builderAdapter, filterValues);
        GetProjectIssuesCommunityQuery.Builder queryBuilder = builderAdapter.getBuilder();
        return new IssueFetchResult(PerimeterType.PROJECT, instanceType, this.fetchAllProjectIssuesCommunity(queryBuilder));
    }

    private List<GitLabIssue> fetchAllProjectIssuesPremium(GetProjectIssuesQuery.Builder preconfiguredBuilder) {
        PagingAdapter.GetProjectIssuesPagingAdapterPremium pagingAdapter = new PagingAdapter.GetProjectIssuesPagingAdapterPremium(preconfiguredBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (projectIssuesQueryData, topLevelErrors) -> GitLabIssueConverter.convertProjectIssuesPremium(projectIssuesQueryData)));
    }

    private List<GitLabIssue> fetchAllProjectIssuesCommunity(GetProjectIssuesCommunityQuery.Builder preconfiguredBuilder) {
        PagingAdapter.GetProjectIssuesPagingAdapterCommunity pagingAdapter = new PagingAdapter.GetProjectIssuesPagingAdapterCommunity(preconfiguredBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (projectIssuesQueryData, topLevelErrors) -> GitLabIssueConverter.convertProjectIssuesCommunity(projectIssuesQueryData)));
    }

    public IssueFetchResult getBoardIssues(GitLabRemoteSynchronisation synchronisation, boolean syncForSprints) {
        String perimeter = synchronisation.getPerimeter();
        String boardId = syncForSprints ? GitLabRemoteSynchronisation.getSprintSelectValue(synchronisation.getRemoteSynchronisation()) : synchronisation.getSelectValue();
        if (boardId == null || boardId.isBlank()) {
            throw new UnsupportedOperationException("Cannot query project board issues without a valid board ID.");
        }
        GitLabInstanceType instanceType = this.getInstanceType();
        if (GitLabInstanceType.PREMIUM.equals((Object)instanceType)) {
            GitLabBoardScope scope = this.getBoardScopePremium(perimeter, boardId);
            FilteredBoardIssuesQueryBuilderAdapterPremium.ProjectBuilderAdapterPremium builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterPremium.ProjectBuilderAdapterPremium();
            GetProjectFilteredBoardIssuesQuery query = this.getFilteredBoardIssuesQueryBuilderPremium(perimeter, boardId, scope, builderAdapter).build();
            return new IssueFetchResult(PerimeterType.PROJECT, GitLabInstanceType.PREMIUM, this.getBoardIssuesAndMergeWithNextPages(scope, query, (data, topLevelErrors) -> GitLabIssueConverter.convertProjectBoardIssuesPremium(data), instanceType));
        }
        FilteredBoardIssuesQueryBuilderAdapterCommunity.ProjectBuilderAdapterCommunity builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterCommunity.ProjectBuilderAdapterCommunity();
        GetProjectFilteredBoardIssuesCommunityQuery query = this.getFilteredBoardIssuesQueryBuilderCommunity(perimeter, boardId, builderAdapter).build();
        return new IssueFetchResult(PerimeterType.PROJECT, GitLabInstanceType.COMMUNITY, this.getBoardIssuesAndMergeWithNextPages(null, query, (data, topLevelErrors) -> GitLabIssueConverter.convertProjectBoardIssuesCommunity(data), instanceType));
    }

    private GitLabBoardScope getBoardScopePremium(String perimeter, String boardId) {
        GetProjectBoardScopeQuery scopeQuery = GetProjectBoardScopeQuery.builder().fullPath(perimeter).boardId(boardId).build();
        return this.gitLabClient.executeAndConvert(scopeQuery, (data, topLevelErrors) -> GitLabBoardScopeConverter.convertProjectBoardScope(data));
    }

    public GitLabInstanceType getInstanceType() {
        return this.isInstanceEnterpriseEdition() ? GitLabInstanceType.PREMIUM : GitLabInstanceType.COMMUNITY;
    }

    public int getProjectIssueCount(GitLabRemoteSynchronisation synchronisation, boolean syncForSprints) {
        String perimeter = synchronisation.getPerimeter();
        List<SynchronisationFilterValue> filterValues = syncForSprints ? GitLabRemoteSynchronisation.getSprintFilterValues(synchronisation.getRemoteSynchronisation()) : synchronisation.getFilterValues();
        GitLabInstanceType instanceType = this.getInstanceType();
        if (GitLabInstanceType.PREMIUM.equals((Object)instanceType)) {
            IssuesQueryBuilderAdapterPremium.ProjectIssueCountBuilderAdapterPremium builderAdapter = new IssuesQueryBuilderAdapterPremium.ProjectIssueCountBuilderAdapterPremium();
            builderAdapter.fullPath(perimeter);
            GitLabIssueQueryFilterBuildersPremium.appendFilters(builderAdapter, filterValues);
            GetProjectIssueCountQuery.Builder queryBuilder = builderAdapter.getBuilder();
            return this.fetchProjectIssueCount(queryBuilder);
        }
        IssuesQueryBuilderAdapterCommunity.ProjectIssueCountBuilderAdapterCommunity builderAdapter = new IssuesQueryBuilderAdapterCommunity.ProjectIssueCountBuilderAdapterCommunity();
        builderAdapter.fullPath(perimeter);
        GitLabIssueQueryFilterBuildersCommunity.appendFilters(builderAdapter, filterValues);
        GetProjectIssueCountCommunityQuery.Builder queryBuilder = builderAdapter.getBuilder();
        return this.fetchProjectIssueCountCommunity(queryBuilder);
    }

    private int fetchProjectIssueCount(GetProjectIssueCountQuery.Builder preconfiguredBuilder) {
        return this.gitLabClient.executeAndConvert(preconfiguredBuilder.build(), (queryData, topLevelErrors) -> GitLabIssueCountConverter.convertProjectIssueCount(queryData));
    }

    private int fetchProjectIssueCountCommunity(GetProjectIssueCountCommunityQuery.Builder preconfiguredBuilder) {
        return this.gitLabClient.executeAndConvert(preconfiguredBuilder.build(), (queryData, topLevelErrors) -> GitLabIssueCountConverter.convertProjectIssueCountCommunity(queryData));
    }

    public int getBoardIssueCount(GitLabRemoteSynchronisation synchronisation, boolean syncForSprints) {
        String perimeter = synchronisation.getPerimeter();
        String boardId = syncForSprints ? GitLabRemoteSynchronisation.getSprintSelectValue(synchronisation.getRemoteSynchronisation()) : synchronisation.getSelectValue();
        if (boardId == null || boardId.isBlank()) {
            throw new UnsupportedOperationException("Cannot query project board issue count without a valid board ID.");
        }
        GitLabInstanceType instanceType = this.getInstanceType();
        if (GitLabInstanceType.PREMIUM.equals((Object)instanceType)) {
            GitLabBoardScope scope = this.getBoardScopePremium(perimeter, boardId);
            FilteredBoardIssuesQueryBuilderAdapterPremium.ProjectBoardIssueCountQueryBuilderAdapterPremium builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterPremium.ProjectBoardIssueCountQueryBuilderAdapterPremium();
            GetProjectFilteredBoardIssueCountQuery query = this.getFilteredBoardIssuesQueryBuilderPremium(perimeter, boardId, scope, builderAdapter).build();
            return this.fetchBoardIssueCount(query);
        }
        FilteredBoardIssuesQueryBuilderAdapterCommunity.ProjectBoardIssueCountQueryBuilderAdapterCommunity builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterCommunity.ProjectBoardIssueCountQueryBuilderAdapterCommunity();
        GetProjectFilteredBoardIssueCountCommunityQuery query = this.getFilteredBoardIssuesQueryBuilderCommunity(perimeter, boardId, builderAdapter).build();
        return this.fetchBoardIssueCountCommunity(query);
    }

    private int fetchBoardIssueCount(GetProjectFilteredBoardIssueCountQuery query) {
        return this.gitLabClient.executeAndConvert(query, (queryData, topLevelErrors) -> GitLabIssueCountConverter.convertProjectBoardIssueCount(queryData));
    }

    private int fetchBoardIssueCountCommunity(GetProjectFilteredBoardIssueCountCommunityQuery query) {
        return this.gitLabClient.executeAndConvert(query, (queryData, topLevelErrors) -> GitLabIssueCountConverter.convertProjectBoardIssueCountCommunity(queryData));
    }
}

