/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.converter;

import jakarta.xml.bind.DatatypeConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateConverter {
    private static final String GITLAB_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String GITLAB_DATE_FORMAT = "yyyy-MM-dd";

    public static Date parseDateTime(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(GITLAB_DATE_TIME_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return sdf.parse(date);
        }
        catch (ParseException parseException) {
            return DateConverter.parseDateTimeWithTimeZone(date);
        }
    }

    public static Date parseDateTimeWithTimeZone(String date) {
        try {
            return DatatypeConverter.parseDateTime((String)date).getTime();
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Could not parse GitLab issue Date Time", ex);
        }
    }

    public static Date parseDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(GITLAB_DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return sdf.parse(date);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Could not parse GitLab issue Date", pe);
        }
    }

    private DateConverter() {
        throw new IllegalStateException("This class is not meant to be instantiated.");
    }
}

