/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab;

import jakarta.inject.Inject;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.squashtest.csp.core.bugtracker.core.NamespacedBugtrackerMessageSource;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.api.widget.InternationalizedMenuItem;
import org.squashtest.tm.api.widget.MenuItem;
import org.squashtest.tm.api.widget.TreeNodeType;
import org.squashtest.tm.api.widget.access.AccessRuleBuilder;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.plugin.xsquash4gitlab.Xsquash4GitLabPlugin;
import org.squashtest.tm.plugin.xsquash4gitlab.concurrency.SynchronisedSectionWrapper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.ConfigurationService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SynchronisationService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Configuration(value="squash.tm.plugin.xsquash4gitlab.conf")
@ComponentScan
public class SpringConfig {
    private final SynchronisationService synchronisationService;
    private final ConfigurationService configurationService;
    @Inject
    private InternationalizationHelper langHelper;

    public SpringConfig(SynchronisationService synchronisationService, ConfigurationService configurationService) {
        this.synchronisationService = synchronisationService;
        this.configurationService = configurationService;
    }

    @Bean
    public SynchronisedSectionWrapper synchronisedSectionWrapper() {
        return new SynchronisedSectionWrapper();
    }

    @Bean(name={"squash.tm.plugin.xsquash4gitlab"})
    public Xsquash4GitLabPlugin xsquash4GitLabPlugin() {
        Xsquash4GitLabPlugin plugin = new Xsquash4GitLabPlugin(this.synchronisationService, this.synchronisedSectionWrapper(), this.configurationService);
        plugin.setBeanName("squash.tm.plugin.xsquash4gitlab");
        plugin.setNameKey("henix.xsquash4gitlab.plugin.name");
        plugin.setTypeKey("henix.xsquash4gitlab.plugin.type");
        plugin.setDisplayWorkspace(WorkspaceType.CAMPAIGN_WORKSPACE);
        plugin.setWizardMenu(this.wizardItem());
        return plugin;
    }

    private MenuItem wizardItem() {
        InternationalizedMenuItem item = new InternationalizedMenuItem();
        item.setUrl("plugin/xsquash4gitlab/campaign-wizard");
        item.setAccessRule(AccessRuleBuilder.singleNodeSelection().nodePermission(TreeNodeType.CAMPAIGN, Permissions.WRITE).or().nodePermission(TreeNodeType.ITERATION, Permissions.WRITE).build());
        item.setTooltipKey("henix.xsquash4gitlab.execplan.menu.tooltip");
        item.setLabelKey("henix.xsquash4gitlab.execplan.menu.label");
        item.setMessageSource((MessageSource)this.langHelper);
        item.afterPropertiesSet();
        return item;
    }

    @Bean
    public MessageSource xsquash4GitLabMessageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setCacheSeconds(60);
        messageSource.setBasenames(new String[]{"classpath:/org/squashtest/tm/plugin/xsquash4gitlab/messages"});
        return new NamespacedBugtrackerMessageSource((MessageSource)messageSource, "henix.xsquash4gitlab.");
    }
}

