/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml.properties;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.validation.Errors;
import org.squashtest.tm.plugin.saml.properties.IDPProperties;
import org.squashtest.tm.plugin.saml.properties.MetadataProperties;
import org.squashtest.tm.plugin.saml.properties.SAMLProperties;
import org.squashtest.tm.plugin.saml.properties.SPProperties;

class PropertiesValidator {
    private static final String NOT_BLANK_CODE = "not blank";
    private static final String NOT_BLANK_MSG = "must not be empty";
    private static final String URL_PROTO_INVALID_CODE = "invalid protocol";
    private static final String URL_PROTO_INVALID_MSG = "that property doesn't allow protocol : %s";
    private final Errors errors;
    private final SAMLProperties props;

    PropertiesValidator(SAMLProperties props, Errors errors) {
        this.errors = errors;
        this.props = props;
    }

    public void validate() {
        this.validateIdp();
        this.validateSp();
    }

    private void validateIdp() {
        IDPProperties idp = this.props.getIdp();
        this.rejectIfPathFormatInvalid("idp.metadata-url", idp.getMetadataUrl(), "file", "http", "https");
    }

    private void validateSp() {
        SPProperties sp = this.props.getSp();
        this.rejectIfEmpty("sp.registration-id", sp.getRegistrationId());
        this.rejectIfEmpty("sp.entity-id", sp.getEntityId());
        MetadataProperties meta = sp.getMetadata();
        this.validateResource(meta.getPrivateKey(), "sp.metadata.private-key", "Private key");
        this.validateResource(meta.getCertificate(), "sp.metadata.certificate", "Certificate");
    }

    private void validateResource(Resource resource, String fieldName, String displayName) {
        if (resource == null) {
            this.rejectValue(fieldName, NOT_BLANK_CODE, NOT_BLANK_MSG, new String[0]);
        } else if (!resource.exists()) {
            this.rejectValue(fieldName, "file not found", displayName + " location '" + String.valueOf(resource) + "' does not exist", new String[0]);
        }
    }

    private void rejectIfPathFormatInvalid(String property, String toTest, String ... protocols) {
        if (StringUtils.isBlank((CharSequence)toTest)) {
            this.errors.rejectValue(property, NOT_BLANK_CODE, NOT_BLANK_MSG);
            return;
        }
        Pattern p = Pattern.compile("^(\\w+)://.*");
        Matcher m = p.matcher(toTest);
        if (m.matches()) {
            String protocol = m.group(1);
            boolean valid = false;
            String[] stringArray = protocols;
            int n = protocols.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (protocol.equalsIgnoreCase(s)) {
                    valid = true;
                    break;
                }
                ++n2;
            }
            if (!valid) {
                this.rejectValue(property, URL_PROTO_INVALID_CODE, URL_PROTO_INVALID_MSG, protocol);
            }
        }
    }

    private void rejectIfEmpty(String property, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.errors.rejectValue(property, NOT_BLANK_CODE, NOT_BLANK_MSG);
        }
    }

    private void rejectValue(String propertyName, String errorCode, String message, String ... arguments) {
        String formatted = String.format(message, arguments);
        this.errors.rejectValue(propertyName, errorCode, formatted);
    }
}

