/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal.json;

import java.util.ArrayList;
import java.util.List;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirarest.org.codehaus.jettison.json.JSONArray;
import jirarest.org.codehaus.jettison.json.JSONException;
import jirarest.org.codehaus.jettison.json.JSONObject;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.json.SimpleSprint;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.json.SimpleSprintPickerList;

public class SimpleSprintPickerListJsonParser
implements JsonObjectParser<SimpleSprintPickerList> {
    @Override
    public SimpleSprintPickerList parse(JSONObject json) throws JSONException {
        if (json == null) {
            return null;
        }
        JSONArray jsSuggestions = json.getJSONArray("suggestions");
        List<SimpleSprint> suggestions = this.extractSimpleSprints(jsSuggestions);
        JSONArray jsAllmatches = json.getJSONArray("allMatches");
        List<SimpleSprint> allMatches = this.extractSimpleSprints(jsAllmatches);
        return new SimpleSprintPickerList(suggestions, allMatches);
    }

    private List<SimpleSprint> extractSimpleSprints(JSONArray json) throws JSONException {
        ArrayList<SimpleSprint> sprints = new ArrayList<SimpleSprint>();
        int i = 0;
        while (i < json.length()) {
            JSONObject obj = json.getJSONObject(i);
            if (obj != null) {
                Long id = obj.getLong("id");
                String name = obj.getString("name");
                String stateKey = obj.getString("stateKey");
                sprints.add(new SimpleSprint(id, name, stateKey));
            }
            ++i;
        }
        return sprints;
    }
}

