/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jirarest.com.atlassian.jira.rest.client.api.domain.BasicProject;
import jirarest.com.atlassian.jira.rest.client.api.domain.CimIssueType;
import jirarest.com.atlassian.jira.rest.client.api.domain.CimProject;
import jirarest.com.atlassian.jira.rest.client.internal.json.BasicProjectJsonParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.CimIssueTypeJsonParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonArrayParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirarest.org.codehaus.jettison.json.JSONArray;
import jirarest.org.codehaus.jettison.json.JSONException;
import jirarest.org.codehaus.jettison.json.JSONObject;

public class CimProjectJsonParser
implements JsonObjectParser<CimProject> {
    private final JsonArrayParser<Iterable<CimIssueType>> issueTypesParser = GenericJsonArrayParser.create(new CimIssueTypeJsonParser());
    private final BasicProjectJsonParser basicProjectJsonParser = new BasicProjectJsonParser();

    @Override
    public CimProject parse(JSONObject json) throws JSONException {
        BasicProject basicProject = this.basicProjectJsonParser.parse(json);
        JSONArray issueTypesArray = json.optJSONArray("issuetypes");
        List<CimIssueType> issueTypes = issueTypesArray != null ? (Iterable)this.issueTypesParser.parse(issueTypesArray) : Collections.emptyList();
        Map<String, URI> avatarUris = JsonParseUtil.getAvatarUris(json.getJSONObject("avatarUrls"));
        return new CimProject(basicProject.getSelf(), basicProject.getKey(), basicProject.getId(), basicProject.getName(), avatarUris, issueTypes);
    }
}

