/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.jira.rest.client.internal.async;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import jirarest.com.atlassian.httpclient.api.DefaultResponseTransformation;
import jirarest.com.atlassian.httpclient.api.EntityBuilder;
import jirarest.com.atlassian.httpclient.api.HttpClient;
import jirarest.com.atlassian.httpclient.api.Request;
import jirarest.com.atlassian.httpclient.api.Response;
import jirarest.com.atlassian.httpclient.api.ResponsePromise;
import jirarest.com.atlassian.httpclient.api.ResponseTransformation;
import jirarest.com.atlassian.jira.rest.client.api.RestClientException;
import jirarest.com.atlassian.jira.rest.client.api.domain.util.ErrorCollection;
import jirarest.com.atlassian.jira.rest.client.internal.async.DelegatingPromise;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonArrayParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import jirarest.io.atlassian.util.concurrent.Promise;
import jirarest.javax.annotation.Nullable;
import jirarest.org.codehaus.jettison.json.JSONArray;
import jirarest.org.codehaus.jettison.json.JSONException;
import jirarest.org.codehaus.jettison.json.JSONObject;

public abstract class AbstractAsynchronousRestClient {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private final HttpClient client;

    protected AbstractAsynchronousRestClient(HttpClient client) {
        this.client = client;
    }

    protected final <T> Promise<T> getAndParse(URI uri, JsonParser<?, T> parser) {
        return this.callAndParse(this.client.newRequest(uri).setAccept(JSON_CONTENT_TYPE).get(), parser);
    }

    protected final <I, T> Promise<T> postAndParse(URI uri, I entity, JsonGenerator<I> jsonGenerator, JsonObjectParser<T> parser) {
        ResponsePromise responsePromise = this.client.newRequest(uri).setEntity(this.toEntity(jsonGenerator, entity)).post();
        return this.callAndParse(responsePromise, parser);
    }

    protected final <T> Promise<T> postAndParse(URI uri, JSONObject entity, JsonObjectParser<T> parser) {
        ResponsePromise responsePromise = ((Request.Builder)((Request.Builder)this.client.newRequest(uri).setEntity(entity.toString())).setContentType(JSON_CONTENT_TYPE)).post();
        return this.callAndParse(responsePromise, parser);
    }

    protected final Promise<Void> post(URI uri, String entity) {
        ResponsePromise responsePromise = ((Request.Builder)((Request.Builder)this.client.newRequest(uri).setEntity(entity)).setContentType(JSON_CONTENT_TYPE)).post();
        return this.call(responsePromise);
    }

    protected final Promise<Void> post(URI uri, JSONObject entity) {
        return this.post(uri, entity.toString());
    }

    protected final <T> Promise<Void> post(URI uri, T entity, JsonGenerator<T> jsonGenerator) {
        ResponsePromise responsePromise = this.client.newRequest(uri).setEntity(this.toEntity(jsonGenerator, entity)).post();
        return this.call(responsePromise);
    }

    protected final Promise<Void> post(URI uri) {
        return this.post(uri, "");
    }

    protected final <I, T> Promise<T> putAndParse(URI uri, I entity, JsonGenerator<I> jsonGenerator, JsonObjectParser<T> parser) {
        ResponsePromise responsePromise = this.client.newRequest(uri).setEntity(this.toEntity(jsonGenerator, entity)).put();
        return this.callAndParse(responsePromise, parser);
    }

    protected final <T> Promise<Void> put(URI uri, T entity, JsonGenerator<T> jsonGenerator) {
        ResponsePromise responsePromise = this.client.newRequest(uri).setEntity(this.toEntity(jsonGenerator, entity)).put();
        return this.call(responsePromise);
    }

    protected final Promise<Void> delete(URI uri) {
        ResponsePromise responsePromise = this.client.newRequest(uri).delete();
        return this.call(responsePromise);
    }

    protected final <T> Promise<T> callAndParse(ResponsePromise responsePromise, ResponseHandler<T> responseHandler) {
        Function<Response, T> transformFunction = AbstractAsynchronousRestClient.toFunction(responseHandler);
        ResponseTransformation responseTransformation = (ResponseTransformation)DefaultResponseTransformation.builder().ok(transformFunction).created(transformFunction).others(AbstractAsynchronousRestClient.errorFunction()).build();
        return new DelegatingPromise(responsePromise.transform(responseTransformation));
    }

    protected final <T> Promise<T> callAndParse(ResponsePromise responsePromise, final JsonParser<?, T> parser) {
        ResponseHandler responseHandler = new ResponseHandler<T>(){

            @Override
            public T handle(Response response) throws JSONException, IOException {
                String body = response.getEntity();
                return parser instanceof JsonObjectParser ? ((JsonObjectParser)parser).parse(new JSONObject(body)) : ((JsonArrayParser)parser).parse(new JSONArray(body));
            }
        };
        return this.callAndParse(responsePromise, responseHandler);
    }

    protected final Promise<Void> call(ResponsePromise responsePromise) {
        ResponseTransformation responseTransformation = (ResponseTransformation)DefaultResponseTransformation.builder().ok(AbstractAsynchronousRestClient.constant(null)).created(AbstractAsynchronousRestClient.constant(null)).noContent(AbstractAsynchronousRestClient.constant(null)).others(AbstractAsynchronousRestClient.errorFunction()).build();
        return new DelegatingPromise<Void>(responsePromise.transform(responseTransformation));
    }

    protected HttpClient client() {
        return this.client;
    }

    private static <T> Function<Response, T> errorFunction() {
        return new Function<Response, T>(){

            @Override
            public T apply(Response response) {
                try {
                    String body = response.getEntity();
                    Collection<ErrorCollection> errorMessages = AbstractAsynchronousRestClient.extractErrors(response.getStatusCode(), body);
                    throw new RestClientException(errorMessages, response.getStatusCode());
                }
                catch (JSONException e) {
                    throw new RestClientException(e, response.getStatusCode());
                }
            }
        };
    }

    private static <T> Function<Response, T> toFunction(final ResponseHandler<T> responseHandler) {
        return new Function<Response, T>(){

            @Override
            public T apply(@Nullable Response input) {
                try {
                    return responseHandler.handle(input);
                }
                catch (JSONException e) {
                    throw new RestClientException(e);
                }
                catch (IOException e) {
                    throw new RestClientException(e);
                }
            }
        };
    }

    private static <T> Function<Response, T> constant(final T value) {
        return new Function<Response, T>(){

            @Override
            public T apply(Response input) {
                return value;
            }
        };
    }

    static Collection<ErrorCollection> extractErrors(int status, String body) throws JSONException {
        if (body == null) {
            return Collections.emptyList();
        }
        JSONObject jsonObject = new JSONObject(body);
        JSONArray issues = jsonObject.optJSONArray("issues");
        ImmutableList.Builder results = ImmutableList.builder();
        if (issues != null && issues.length() == 0) {
            JSONArray errors = jsonObject.optJSONArray("errors");
            for (int i = 0; i < errors.length(); ++i) {
                JSONObject currentJsonObject = errors.getJSONObject(i);
                results.add((Object)AbstractAsynchronousRestClient.getErrorsFromJson(currentJsonObject.getInt("status"), currentJsonObject.optJSONObject("elementErrors")));
            }
        } else {
            results.add((Object)AbstractAsynchronousRestClient.getErrorsFromJson(status, jsonObject));
        }
        return results.build();
    }

    private static ErrorCollection getErrorsFromJson(int status, JSONObject jsonObject) throws JSONException {
        JSONObject jsonErrors = jsonObject.optJSONObject("errors");
        JSONArray jsonErrorMessages = jsonObject.optJSONArray("errorMessages");
        Collection<Object> errorMessages = jsonErrorMessages != null ? JsonParseUtil.toStringCollection(jsonErrorMessages) : Collections.emptyList();
        Map<String, String> errors = jsonErrors != null && jsonErrors.length() > 0 ? JsonParseUtil.toStringMap(jsonErrors.names(), jsonErrors) : Collections.emptyMap();
        return new ErrorCollection(status, errorMessages, errors);
    }

    private <T> EntityBuilder toEntity(final JsonGenerator<T> generator, final T bean) {
        return new EntityBuilder(){

            @Override
            public EntityBuilder.Entity build() {
                return new EntityBuilder.Entity(){

                    @Override
                    public Map<String, String> getHeaders() {
                        return Collections.singletonMap("Content-Type", AbstractAsynchronousRestClient.JSON_CONTENT_TYPE);
                    }

                    @Override
                    public InputStream getInputStream() {
                        try {
                            return new ByteArrayInputStream(generator.generate(bean).toString().getBytes(Charset.forName("UTF-8")));
                        }
                        catch (JSONException e) {
                            throw new RestClientException(e);
                        }
                    }
                };
            }
        };
    }

    protected static interface ResponseHandler<T> {
        public T handle(Response var1) throws JSONException, IOException;
    }
}

